import { Meta } from '@storybook/react';
import * as React from 'react';

import { Rows } from './Rows';

export const OneLine = () => <Rows text={`just text in one line`} />;

export const StringWithLines = () => (
   <Rows
      text={`line 1
line 2
line 3`}
   />
);

export const StringWithBreak = () => (
   <Rows
      text={`line 1

line 3`}
   />
);

export const StringWithTabs = () => (
   <Rows
      text={`line 1
\tline 2
\t\tline 3`}
   />
);

export const ArrayOfString = () => <Rows text={['line 1', 'line 2', 'line 3']} />;

export default {
   decorators: [storyFn => <div style={{ whiteSpace: 'pre', fontFamily: 'var(--monospace-fonts)' }}>{storyFn()}</div>],
   title: 'small_components/Rows',
} as Meta;
