import * as React from 'react';

interface IProps {
   text: string | string[];
}

export const Rows = React.memo(({ text }: IProps) => {
   let rows: string[] = [];

   if (typeof text === 'string') {
      rows = text.includes('\n') ? text.split('\n') : [text];
   }

   if (text instanceof Array) {
      rows = text;
   }

   return (
      <>
         {rows.map((row, i) => (
            // eslint-disable-next-line react/no-array-index-key
            <React.Fragment key={i}>
               {row || ''}
               {i < rows.length - 1 ? <br /> : null}
            </React.Fragment>
         ))}
      </>
   );
});

Rows.displayName = 'Rows';
