import { Button } from '@yandex-cloud/uikit';
import * as React from 'react';

import { BottomFooter } from '../BottomFooter/BottomFooter';

import styles from './SaveFooter.module.css';

interface IProps {
   cancelText?: string;
   disabled?: boolean;
   saveText?: string;

   onCancel(): void;

   onSave(): void;
}

export const SaveFooter = React.memo(
   ({ disabled = false, cancelText = 'Cancel', saveText = 'Save changes', onCancel, onSave }: IProps) => (
      <BottomFooter className={styles.saveFooter} data-e2e={'SaveFooter'}>
         <Button view={'action'} extraProps={{ 'data-e2e': 'SaveFooter:save' }} onClick={onSave} disabled={disabled}>
            {saveText}
         </Button>
         <Button extraProps={{ 'data-e2e': 'SaveFooter:cancel' }} onClick={onCancel}>
            {cancelText}
         </Button>
      </BottomFooter>
   ),
);
