import { IconDefinition } from '@fortawesome/fontawesome-svg-core';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { TabItem } from '@yandex-data-ui/common';
import React, { ReactNode } from 'react';

import { formatNumber } from '../../formatters';

import classes from './SmartTab.module.css';

export interface SmartTabProps extends TabItem<any> {
   /**
    * Признак "вкладки"
    *
    * В production сборке при итерации через React.children ломаются displayName.
    * Это из-за того, что для каждого из child генерируется обертка React.Fragment.
    *
    * Один из вариантов решения - зафорсить значение некой пропсы, чтобы был признак, по которому отсеивать детей.
    *
    * Обычно SmartTabs должны использовать SmartTab в качестве элемента, но если хочется свой компонент для вкладки,
    * то он тоже должен у себя прописать этот defaultProps
    *
    * @see inspired by https://mparavano.medium.com/find-filter-react-children-by-type-d9799fb78292
    */
   __ROLE?: 'SmartTab';
   children: ReactNode;
   count?: number;
   emptyIcon?: IconDefinition;
   fillIcon?: IconDefinition;
   isEmpty?: boolean;
   isRequired?: boolean;
}

export const SmartTab: React.FC<SmartTabProps> = React.memo(
   ({ title, isEmpty, emptyIcon, fillIcon, count, isRequired }) => {
      let icon: ReactNode = null;
      if (isEmpty === true && emptyIcon) {
         icon = <FontAwesomeIcon icon={emptyIcon} fixedWidth={true} />;
      } else if (isEmpty === false && fillIcon) {
         icon = <FontAwesomeIcon icon={fillIcon} fixedWidth={true} />;
      }

      return (
         <>
            {icon} {title}
            {count !== undefined ? <span className={classes.count}> {formatNumber(count)}</span> : null}
            {isRequired ? <span className={classes.required}>*</span> : null}
         </>
      );
   },
);

SmartTab.defaultProps = {
   __ROLE: 'SmartTab',
};

SmartTab.displayName = 'SmartTab';
