import {
   faFileCode as faFileCodeFill,
   faFileCode as faFileCodeEmpty,
} from '@fortawesome/free-solid-svg-icons/faFileCode';
import { boolean, number } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { TabsDirection } from '@yandex-cloud/uikit';
import React, { useEffect, useState } from 'react';

import { SmartTab } from './SmartTab';
import { SmartTabs } from './SmartTabs';

const Template = ({ direction }: { direction: TabsDirection }) => {
   const [tab, setTab] = useState('tab1');

   useEffect(() => {
      setTimeout(() => {
         setTab('tab2');
      }, 2000);
   }, []);

   return (
      <SmartTabs activeTab={tab} onSelectTab={setTab} direction={direction}>
         <SmartTab
            id={'tab1'}
            title={'Init command'}
            isEmpty={boolean('isEmpty', false)}
            emptyIcon={faFileCodeEmpty}
            fillIcon={faFileCodeFill}
            count={number('count', 3)}
         >
            Tab #1 content
         </SmartTab>

         <SmartTab
            id={'tab2'}
            title={'Start command'}
            isRequired={true}
            isEmpty={boolean('isEmpty', false)}
            emptyIcon={faFileCodeEmpty}
            fillIcon={faFileCodeFill}
         >
            Tab #2 content
         </SmartTab>

         <SmartTab
            id={'tab3'}
            title={'Liveness probe'}
            disabled={true}
            isEmpty={boolean('isEmpty', false)}
            emptyIcon={faFileCodeEmpty}
            fillIcon={faFileCodeFill}
         >
            Tab #3 content
         </SmartTab>
      </SmartTabs>
   );
};

export const Horizontal = () => <Template direction={TabsDirection.Horizontal} />;

export const Vertical = () => <Template direction={TabsDirection.Vertical} />;

export default {
   title: 'small_components/SmartTabs',
} as Meta;
