import { Meta } from '@storybook/react';
import React from 'react';
import { useLocation } from 'react-router';

import { routerDecorator } from '../../_storybook';

import { SmartTab } from './SmartTab';
import { SmartTabsWithUrl } from './SmartTabsWithUrl';

export const Regular = () => {
   const location = useLocation();

   return (
      <>
         <h1>Location hash: "{location.hash}"</h1>

         <SmartTabsWithUrl defaultTab={'form'}>
            <SmartTab id={'form'} title={'Form'}>
               FORM
            </SmartTab>
            <SmartTab id={'secrets'} title={'Secrets'}>
               SECRETS
            </SmartTab>
         </SmartTabsWithUrl>
      </>
   );
};

export default {
   decorators: [routerDecorator],
   title: 'small_components/SmartTabsWithUrl',
} as Meta;
