import React, { useCallback } from 'react';
import { useHistory, useLocation } from 'react-router';

import { SmartTabs, SmartTabsProps } from './SmartTabs';

interface Props extends Omit<SmartTabsProps, 'activeTab' | 'onSelectTab'> {
   className?: string;
   defaultTab: string;
}

export const SmartTabsWithUrl: React.FC<Props> = React.memo(({ defaultTab, ...props }) => {
   const history = useHistory();
   const location = useLocation();

   const handleSelectTab = useCallback(
      (tab: string) => {
         history.replace({ hash: tab === defaultTab ? '' : tab });
      },
      [defaultTab, history],
   );

   return (
      <SmartTabs
         {...props}
         activeTab={location.hash ? location.hash.substring(1) : defaultTab}
         onSelectTab={handleSelectTab}
      />
   );
});

SmartTabsWithUrl.displayName = 'SmartTabsWithUrl';
