import isAfter from 'date-fns/isAfter';
import React, { useCallback, useMemo } from 'react';

import { useLocalStorage } from '../../react_hooks';
import { Banner } from '../Banner/Banner';

interface Props {
   action: string;
   bannerId: string;
   endDateISO: string;
   link: string;
   title: string;
}

export const TimedBanner: React.FC<Props> = React.memo(({ action, bannerId, endDateISO, link, title, children }) => {
   const endDate = useMemo(() => new Date(endDateISO), [endDateISO]);

   const [visible, setVisible] = useLocalStorage(`banners_${bannerId}`, true);

   const close = useCallback(() => setVisible(false), [setVisible]);

   if (!visible || (endDate ? isAfter(new Date(), endDate) : false)) {
      return null;
   }

   return (
      <Banner action={action} title={title} onClose={close} link={link}>
         {children}
      </Banner>
   );
});

TimedBanner.displayName = 'TimedBanner';
