import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { IUserOrGroup, UserOrGroupType } from '../../_models';
import { outlineDecorator, systemUsersDecorator } from '../../_storybook';
import { json } from '../../formatters';

import { UserList } from './UserList';

// noinspection SpellCheckingInspection
const userList: IUserOrGroup[] = [
   { id: 'khoden', type: UserOrGroupType.People },
   { id: 'iperfilyev', type: UserOrGroupType.People },
   { id: 'wall-e', type: UserOrGroupType.System },
   { id: 'idm', type: UserOrGroupType.System },
   { id: 'svc_afisha', type: UserOrGroupType.Group },
   { id: 'svc_afisha_administration', type: UserOrGroupType.Group },
   { id: 'svc_internalmdb_hardware_management', type: UserOrGroupType.Group },
   { id: 'yandex_mnt_sa_runtime_mondev_dep98945', type: UserOrGroupType.Group },

   { id: '103591', type: UserOrGroupType.Group },
   { id: '8666', type: UserOrGroupType.Group },
   { id: '36753', type: UserOrGroupType.Group },
];

const EditableUserListStory = () => {
   // hooks
   const [value, setValue] = useState(userList);

   // handlers
   const update = (e: SyntheticEvent | null, v: IUserOrGroup[]) => setValue(v);

   // render
   return (
      <>
         <UserList value={value} editable={true} onChange={update} resolveGroups={true} addGroupType={true} />

         <pre>{json(value)}</pre>
      </>
   );
};

export const Editable = () => <EditableUserListStory />;

export const ReadonlyAndForceAvatars = () => (
   <UserList value={userList} editable={boolean('editable', false)} forceAvatars={boolean('forceAvatars', true)} />
);

export const Invalid = () => <UserList value={userList} editable={true} />;

export const Wrapped = () => (
   <div style={{ maxWidth: '20rem', outline: '1px solid red' }}>
      <UserList value={userList} editable={false} resolveGroups={true} addGroupType={true} />
   </div>
);

export default {
   decorators: [outlineDecorator, systemUsersDecorator],
   title: 'small_components/UserList',
} as Meta;
