import { Meta, Story } from '@storybook/react';
import * as React from 'react';

import { UserOrGroupType } from '../../_models';
import { outlineDecorator, systemUsersDecorator } from '../../_storybook';

import { UserName } from './UserName';

interface StoryArgs {
   addGroupType?: boolean;
   avatar?: boolean;
   hideAvatar?: boolean;
   id: string;
   name?: string;
   type: UserOrGroupType;
}

const Template: Story<StoryArgs> = ({ addGroupType, id, name, type, hideAvatar, avatar }) => (
   <UserName value={{ id, name, type }} hideAvatar={hideAvatar} avatar={avatar} addGroupType={addGroupType} />
);

export const WithPeople = Template.bind({});
WithPeople.args = { id: 'khoden', type: UserOrGroupType.People };

export const WithEmail = Template.bind({});
WithEmail.args = { id: 'khoden@yandex-team.ru', type: UserOrGroupType.People };

export const WithGroup = Template.bind({});
WithGroup.args = { id: 'bot', type: UserOrGroupType.Group };

export const WithExplicitAvatar = Template.bind({});
WithExplicitAvatar.args = { id: 'bot', type: UserOrGroupType.Group, avatar: true };

export const WithoutExplicitAvatar = Template.bind({});
WithoutExplicitAvatar.args = { id: 'khoden', type: UserOrGroupType.People, avatar: false };

export const WithServiceGroup = Template.bind({});
WithServiceGroup.args = {
   addGroupType: true,
   hideAvatar: true,
   id: 'svc_afisha',
   name: 'Афиша',
   type: UserOrGroupType.Group,
};

export const WithServiceScopeGroup = Template.bind({});
WithServiceScopeGroup.args = {
   addGroupType: true,
   hideAvatar: true,
   id: 'svc_afisha_administration',
   name: 'Администрирование (Афиша)',
   type: UserOrGroupType.Group,
};

export const WithDepartmentGroup = Template.bind({});
WithDepartmentGroup.args = {
   addGroupType: true,
   id: 'yandex_mnt_sa_runtime_mondev_dep98945',
   type: UserOrGroupType.Group,
};

export const ForIDM = Template.bind({});
ForIDM.args = { id: 'idm', type: UserOrGroupType.System };

export const ForWallE = Template.bind({});
ForWallE.args = { id: 'wall-e', type: UserOrGroupType.System };

export default {
   decorators: [outlineDecorator, systemUsersDecorator],
   title: 'small_components/UserName',
} as Meta;
