import { getAbcServiceLink } from './UserName';

describe('small_components|UserName', () => {
   it('should get simple abc service link', () => {
      expect(getAbcServiceLink('svc_afisha')).toBe('https://abc.yandex-team.ru/services/afisha/');
   });

   it('should get abc service link with scope', () => {
      expect(getAbcServiceLink('svc_afisha_administration')).toBe(
         'https://abc.yandex-team.ru/services/afisha/?scope=administration',
      );
   });

   it('should get abc service link with multiple words scope', () => {
      expect(getAbcServiceLink('svc_afisha_services_management')).toBe(
         'https://abc.yandex-team.ru/services/afisha/?scope=services_management',
      );
   });

   it('should get abc service link ignoring unknown scopes', () => {
      expect(getAbcServiceLink('svc_afisha_xxx')).toBe('https://abc.yandex-team.ru/services/afisha_xxx/');
   });

   it('should get abc service link with dashes', () => {
      expect(getAbcServiceLink('svc_maps-front-users_development')).toBe(
         'https://abc.yandex-team.ru/services/maps-front-users/?scope=development',
      );
   });
});
