import { faBiohazard } from '@fortawesome/free-solid-svg-icons';
import { ComponentMeta, Story } from '@storybook/react';
import { CardTheme } from '@yandex-cloud/uikit';
import React, { PropsWithChildren } from 'react';

import { cardThemes, PlateSize, plateSizes, WarningPlate, WarningPlateProps } from './WarningPlate';

const Template: Story<PropsWithChildren<WarningPlateProps>> = props => <WarningPlate {...props} />;

export const Default = Template.bind({});

export const SmallSize = Template.bind({});
SmallSize.args = { size: 's' };

export const Info = Template.bind({});
Info.args = { theme: 'info', children: 'Some information' };

export const Warning = Template.bind({});
Warning.args = { theme: 'warning' };

export const Error = Template.bind({});
Error.args = { theme: 'danger', children: 'Error' };

export const ErrorWithSecondRaw = Template.bind({});
ErrorWithSecondRaw.args = {
   children: 'Error',
   secondRaw: <div style={{ fontSize: '2em', lineHeight: '1.23em' }}>WTF?</div>,
   theme: 'danger',
};

export const UnknownSeverity = Template.bind({});
UnknownSeverity.args = { theme: 'xxx' as any, children: 'Some information' };

export const CustomIcon = Template.bind({});
CustomIcon.args = { icon: faBiohazard, children: 'Some information' };

export const BigWarning = Template.bind({});
BigWarning.args = {
   children: (
      <>
         Enabled logs will rise the requested resources:
         <br />
         <b>+0,5 core of CPU, +0,5 GB of RAM, +0,5 GB of Disk</b>
      </>
   ),
};

export const AllThemesAndSizes: Story<Omit<WarningPlateProps, 'theme' | 'size'>> = props => {
   const themes: CardTheme[] = [...Array.from(cardThemes), 'unknown' as any];
   const sizes: PlateSize[] = [...Array.from(plateSizes), 'unknown' as any];

   return (
      <>
         {themes.map(theme =>
            sizes.map(size => (
               <WarningPlate key={theme + size} {...props} theme={theme} size={size}>
                  Some "{theme}" content
               </WarningPlate>
            )),
         )}
      </>
   );
};

export default {
   args: {
      children: 'Text of warning',
   },
   argTypes: {
      children: { type: 'string' },
      secondRaw: { type: 'string' },
   },
   component: WarningPlate,
   title: 'small_components/WarningPlate',
} as ComponentMeta<typeof WarningPlate>;
