import * as React from 'react';
import * as ReactDOM from 'react-dom';

import { WindowTitle } from './WindowTitle';

describe('WindowTitle', () => {
   let div: HTMLDivElement;
   beforeEach(() => {
      window.document.title = 'before test';
      div = document.createElement('div');
   });

   it('should set only suffix if value is empty', () => {
      ReactDOM.render(<WindowTitle value={''} />, div);

      expect(window.document.title).toBe('WALL-E');
   });

   it('should change title (default suffix)', () => {
      ReactDOM.render(<WindowTitle value={'test title'} />, div);

      expect(window.document.title).toBe('test title - WALL-E');

      ReactDOM.unmountComponentAtNode(div);
   });

   it('should return previous title on unmount', () => {
      ReactDOM.render(<WindowTitle value={'test title'} />, div);
      ReactDOM.unmountComponentAtNode(div);

      expect(window.document.title).toBe('before test');
   });

   it('should be able to change suffix', () => {
      ReactDOM.render(<WindowTitle value={'test title'} suffix={'TODO'} />, div);

      expect(window.document.title).toBe('test title - TODO');

      ReactDOM.unmountComponentAtNode(div);
   });
});
