import { string } from 'prop-types';
import * as React from 'react';

interface IProps {
   suffix?: string;
   value: string;
}

/**
 * @deprecated use useTitle
 */
export class WindowTitle extends React.PureComponent<IProps> {
   public static defaultProps = {
      suffix: 'WALL-E',
   };

   public static propTypes = {
      suffix: string,
      value: string.isRequired,
   };

   private previousTitle = '';

   public componentDidMount(): void {
      const { suffix, value } = this.props;
      this.previousTitle = window.document.title;

      window.document.title = value ? `${value} - ${suffix}` : suffix!;
   }

   public componentWillUnmount(): void {
      window.document.title = this.previousTitle;
   }

   public render() {
      return null;
   }
}
