import * as React from 'react';
import { PropsWithChildren, SyntheticEvent } from 'react';

import { classNames } from '../formatters';
import { autobind } from '../utils';

import { ISuggestBaseEntity } from './models';
import classes from './SuggestItem.module.css';

interface IProps {
   avoidAddingPadding?: boolean;
   item: ISuggestBaseEntity;

   onSelect(e: SyntheticEvent, entity: ISuggestBaseEntity): void;

   focusInput(e: SyntheticEvent): void;
}

export class SuggestItem extends React.PureComponent<IProps> {
   public static defaultProps = {
      avoidAddingPadding: false,
   };

   public static propTypes = {};

   private ref = React.createRef<HTMLDivElement>();

   public render() {
      return (
         <div
            className={classNames(classes.suggestItem, { [classes.withPaddings]: !this.props.avoidAddingPadding })}
            tabIndex={0}
            onKeyDown={this.onKeyDown}
            ref={this.ref}
            onClick={this.onSelect}
            role={'treeitem'}
         >
            {this.props.children}
         </div>
      );
   }

   private focusNext(e: React.KeyboardEvent<HTMLDivElement>) {
      if (this.ref.current) {
         if (this.ref.current.nextSibling) {
            (this.ref.current.nextSibling as HTMLDivElement).focus();
         } else {
            this.props.focusInput(e);
         }
      }
   }

   private focusPrevious(e: React.KeyboardEvent<HTMLDivElement>) {
      if (this.ref.current) {
         if (this.ref.current.previousSibling) {
            (this.ref.current.previousSibling as HTMLDivElement).focus();
         } else {
            this.props.focusInput(e);
         }
      }
   }

   @autobind
   private onKeyDown(e: React.KeyboardEvent<HTMLDivElement>): void {
      switch (e.key) {
         case 'ArrowDown':
            e.preventDefault();
            this.focusNext(e);
            break;

         case 'ArrowUp':
            e.preventDefault();
            this.focusPrevious(e);
            break;

         case 'Enter':
            e.preventDefault();
            this.onSelect(e);
            break;

         default:
            break;
      }
   }

   @autobind
   private onSelect(e: SyntheticEvent) {
      this.props.onSelect(e, this.props.item);
   }
}

export const EmptySuggestItem = ({ children }: PropsWithChildren<{}>) => (
   <div className={classNames(classes.suggestItem, classes.withPaddings)}>{children}</div>
);

EmptySuggestItem.displayName = 'EmptySuggestItem';
