import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { narrowDecorator, outlineDecorator } from '../../../_storybook';
import { SuggestLayer } from '../../models';

import { IStaffGroup } from './models';
import { StaffGroupItem } from './StaffGroupItem';

storiesOf('suggestions/StaffGroupItem', module)
   .addDecorator(outlineDecorator)
   .addDecorator(narrowDecorator)
   .add('regular', () => {
      const item: IStaffGroup = {
         click_urls: [
            '//clck.yandex.ru/click/dtype=SAAS/p=0/saas_url=https%3A%2F%2Fstaff.yandex-team.ru%2Fgroups%2Fsvc_afisha_administration/robot=0/r=s_suggest%253A%2522svc_afisha_administration%252A%2522%2B%257C%2Bsvc_afisha_administration/service=intrasearch-people/kps=75675/uid=is1120000000097260/yandexuid=is1120000000097260/reqid=1562677881372908-15695398614409278071-sas1-3757-sas-saas-mmeta-17000-SAAS/raId=0652A3F95325093E/slots=102711,0,57;149872,0,87/how=rlv/*data=url%3Dhttps%3A%2F%2Fstaff.yandex-team.ru%2Fgroups%2Fsvc_afisha_administration',
         ],
         department: null,
         department_id: null,
         id: '28213',
         layer: SuggestLayer.Groups,
         service: null,
         service_id: null,
         slug: 'svc_afisha_administration',
         title: 'Администрирование (Афиша и Билеты)',
         type: 'servicerole',
         url: 'https://staff.yandex-team.ru/groups/svc_afisha_administration',
      };

      return <StaffGroupItem item={item} />;
   });
