import * as React from 'react';

import { AccentFirstLetter } from '../../../small_components';

import { IStaffGroup } from './models';
import classes from './StaffGroupItem.module.css';

interface IProps {
   item: IStaffGroup;
}

export const StaffGroupItem = React.memo(({ item }: IProps) => {
   return (
      <div className={classes.item}>
         <div className={classes.info}>
            <div>
               <AccentFirstLetter value={item.title} />, <span className={classes.slug}>{item.slug}</span>
            </div>

            {item.department_id ? <div className={classes.department}>{item.department}</div> : null}
         </div>
      </div>
   );
});

StaffGroupItem.displayName = 'StaffGroupItem';
