import * as React from 'react';
import { Observable } from 'rxjs';

import { suggestApi } from '../../api';
import { ISuggestStrategy } from '../models';

import { IStaffGroup } from './models';
import { StaffGroupItem } from './StaffGroupItem';

export class StaffGroupStrategy implements ISuggestStrategy {
   public avoidAddingPaddings = true;

   public load(query: string): Observable<IStaffGroup[]> {
      return suggestApi.findGroups(query.replace(/^@/, ''));
   }

   public renderItem(entity: IStaffGroup): JSX.Element {
      return <StaffGroupItem item={entity} />;
   }

   public getQueryFromEntity(entity: IStaffGroup): string {
      return entity ? entity.title : '';
   }

   public getPlaceholder(): string {
      return 'Group name';
   }
}
