import * as React from 'react';
import { Observable } from 'rxjs';

import { suggestApi } from '../../api';
import { ISuggestStrategy } from '../models';

import { IIssue } from './models';
import classes from './strategy.module.css';

export class IssuesStrategy implements ISuggestStrategy {
   public load(query: string): Observable<IIssue[]> {
      return suggestApi.findIssues(query);
   }

   public renderItem(entity: IIssue): JSX.Element {
      return (
         <div className={classes.item}>
            {entity.id}: <span className={classes.title}>{entity.title}</span>
         </div>
      );
   }

   public getQueryFromEntity(entity: IIssue): string {
      return entity ? entity.id : '';
   }

   public getPlaceholder(): string {
      return 'Ticket id';
   }
}
