import { Observable } from 'rxjs';

import { ISuggestBaseEntity } from '../models';

export interface ISuggestStrategy {
   avoidAddingPaddings?: boolean;

   /**
    * Резолвит запрос в массив подсказок
    *
    * Если выбирать нужно из локального массива,
    * то фильтрация и ограничение числа элементов должны быть реализованы в этом методе.
    *
    * @param query Введённое пользователем значение в поле
    */
   load(query: string): Observable<ISuggestBaseEntity[]>;

   /**
    * Рендерит подсказку
    *
    * @param entity Подсказка
    * @param query Введённое пользователем значение в поле (для подсветки вхождения)
    */
   renderItem(entity: ISuggestBaseEntity, query: string): JSX.Element;

   /**
    * Создаёт объект из запроса, в случае  allowCreate=true
    */
   getEntityFromQuery?(query: string, suggestions: ISuggestBaseEntity[]): ISuggestBaseEntity;

   /**
    * Резолвит строку запроса из подсказки
    *
    * После выбора подсказки значение в поле заменяется на то, что вернётся из этого метода
    *
    * @param entity
    */
   getQueryFromEntity(entity: ISuggestBaseEntity): string;

   /**
    * Обычный placeholder
    */
   getPlaceholder(): string;
}
