import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { narrowDecorator, outlineDecorator } from '../../../_storybook';
import { SuggestLayer } from '../../models';

import { IStaffPerson } from './models';
import { StaffPersonItem } from './StaffPersonItem';

storiesOf('suggestions/StaffPersonItem', module)
   .addDecorator(outlineDecorator)
   .addDecorator(narrowDecorator)
   .add('regular', () => {
      const item: IStaffPerson = {
         bicycles: [],
         cars: [],
         click_urls: [
            '//clck.yandex.ru/click/dtype=SAAS/p=0/saas_url=https%3A%2F%2Fstaff.yandex-team.ru%2Fkhoden/robot=0/r=s_suggest%253A%2522khoden%252A%2522%2B%257C%2Bz_people_name%253Akhoden/service=intrasearch-people/kps=76768/uid=is1120000000097260/yandexuid=is1120000000097260/reqid=1562674250985198-12167991434778439237-sas1-7171-sas-saas-mmeta-17000-SAAS/raId=C085F4E4A24611FD/slots=102711,0,11;149870,0,11/how=rlv/*data=url%3Dhttps%3A%2F%2Fstaff.yandex-team.ru%2Fkhoden',
         ],
         department_name: 'Cloud infrastructure UI Team',
         id: 'khoden',
         is_dismissed: false,
         is_memorial: false,
         is_robot: false,
         layer: SuggestLayer.People,
         login: 'khoden',
         phone: null,
         staff_id: 41111,
         title: 'Artem Berezin',
         uid: '1120000000097260',
         url: 'https://staff.yandex-team.ru/khoden',
      };

      return <StaffPersonItem item={item} />;
   })
   .add('fired', () => {
      const item: IStaffPerson = {
         bicycles: [],
         cars: [],
         click_urls: [
            '//clck.yandex.ru/click/dtype=SAAS/p=0/saas_url=https%3A%2F%2Fstaff.yandex-team.ru%2Fjiojiajiu/robot=0/r=s_suggest%253A%2522jiojiajiu%252A%2522%2B%257C%2Bz_people_name%253Ajiojiajiu/service=intrasearch-people/kps=76768/uid=is1120000000097260/yandexuid=is1120000000097260/reqid=1562676043681112-11645306183557306607-sas1-8693-sas-saas-mmeta-17000-SAAS/raId=6E06BE861C6AD3BF/slots=102710,0,67;149870,0,11/how=rlv/*data=url%3Dhttps%3A%2F%2Fstaff.yandex-team.ru%2Fjiojiajiu',
         ],
         department_name: 'Group of development for Firefox',
         id: 'jiojiajiu',
         is_dismissed: true,
         is_memorial: false,
         is_robot: false,
         layer: SuggestLayer.People,
         login: 'jiojiajiu',
         phone: '6671',
         staff_id: 6043,
         title: 'Guro Bokum',
         uid: '1120000000009922',
         url: 'https://staff.yandex-team.ru/jiojiajiu',
      };

      return <StaffPersonItem item={item} />;
   });
