import * as React from 'react';

import { classNames } from '../../../formatters';
import { AccentFirstLetter, Avatar } from '../../../small_components';

import { IStaffPerson } from './models';
import classes from './StaffPersonItem.module.css';

interface IProps {
   item: IStaffPerson;
}

export const StaffPersonItem = React.memo(({ item }: IProps) => (
   <div
      className={classNames(classes.item, {
         [classes.fired]: item.is_dismissed,
      })}
   >
      <div className={classes.info}>
         <div>
            <AccentFirstLetter value={item.title} />
            &#65279;, <span className={classes.login}>{item.login}</span>
         </div>
         {item.is_dismissed ? 'Dismissed' : <div className={classes.department}>{item.department_name}</div>}
      </div>
      <Avatar login={item.login} big={true} />
   </div>
));

StaffPersonItem.displayName = 'StaffPersonItem';
