import * as React from 'react';
import { Observable } from 'rxjs';

import { EMAIL_HOST, YT_EMAIL_REGEXP } from '../../../_models';
import { suggestApi } from '../../api';
import { SuggestLayer } from '../../models';
import { ISuggestStrategy } from '../models';

import { IStaffPerson } from './models';
import { StaffPersonItem } from './StaffPersonItem';

export class StaffStrategy implements ISuggestStrategy {
   public avoidAddingPaddings = true;

   public load(query: string): Observable<IStaffPerson[]> {
      return suggestApi.findPeople(query);
   }

   public renderItem(entity: IStaffPerson): JSX.Element {
      return <StaffPersonItem item={entity} />;
   }

   public getEntityFromQuery(query: string, suggestions: IStaffPerson[]): IStaffPerson {
      const exist = suggestions.find(s => s.login === query);
      if (exist) {
         return exist;
      }

      const { login, email } = this.parseQuery(query);

      return {
         bicycles: [],
         cars: [],
         department_name: '',
         id: email,
         is_dismissed: false,
         is_memorial: false,
         is_robot: false,
         layer: SuggestLayer.People,
         login,
         phone: '',
         staff_id: 0,
         title: login,
         uid: login,
         url: `https://staff.yandex-team.ru/${login}`,
      };
   }

   public getQueryFromEntity(entity: IStaffPerson): string {
      return entity ? entity.login : '';
   }

   public getPlaceholder(): string {
      return 'Login or email';
   }

   private parseQuery(query: string) {
      if (YT_EMAIL_REGEXP.test(query)) {
         return {
            email: query,
            login: query.replace(EMAIL_HOST, ''),
         };
      }

      const login = query.replace(/^@/, '').replace(/@$/, '');

      return {
         email: `${login}${EMAIL_HOST}`,
         login,
      };
   }
}
