import * as React from 'react';

import { SuggestLayer } from '../../models';
import { StaffGroupItem } from '../groups/StaffGroupItem';
import { StaffPersonItem } from '../people/StaffPersonItem';

import { StaffPersonOrGroup } from './models';

interface IProps {
   item: StaffPersonOrGroup;
}

export const StaffPeopleOrGroupItem = React.memo(({ item }: IProps) => {
   switch (item.layer) {
      case SuggestLayer.People:
         return <StaffPersonItem item={item} />;

      case SuggestLayer.Groups:
         return <StaffGroupItem item={item} />;

      default:
         return <div>[Unknown item type]</div>;
   }
});

StaffPeopleOrGroupItem.displayName = 'StaffPeopleOrGroupItem';
