import * as React from 'react';
import { Observable } from 'rxjs';

import { suggestApi } from '../../api';
import { SuggestLayer } from '../../models';
import { ISuggestStrategy } from '../models';

import { StaffPersonOrGroup } from './models';
import { StaffPeopleOrGroupItem } from './StaffPeopleOrGroupItem';

export class StaffPeopleOrGroupStrategy implements ISuggestStrategy {
   public avoidAddingPaddings = true;

   public load(query: string): Observable<StaffPersonOrGroup[]> {
      return suggestApi.findPeopleOrGroups(query.replace(/^@/, ''));
   }

   public renderItem(entity: StaffPersonOrGroup): JSX.Element {
      return <StaffPeopleOrGroupItem item={entity} />;
   }

   public getQueryFromEntity(entity: StaffPersonOrGroup): string {
      if (!entity) {
         return '';
      }

      switch (entity.layer) {
         case SuggestLayer.Groups:
            return entity.slug;
         case SuggestLayer.People:
            return entity.login;
         default:
            return '';
      }
   }

   public getPlaceholder(): string {
      return 'Login or group';
   }
}
