import * as React from 'react';
import { Observable } from 'rxjs';

import { suggestApi } from '../../api';
import { ISuggestStrategy } from '../models';

import { IQueue } from './models';

export class QueuesStrategy implements ISuggestStrategy {
   public load(query: string): Observable<IQueue[]> {
      return suggestApi.findQueues(query);
   }

   public renderItem(entity: IQueue): JSX.Element {
      return <div>{entity.id}</div>;
   }

   public getQueryFromEntity(entity: IQueue): string {
      return entity ? entity.id : '';
   }

   public getPlaceholder(): string {
      return 'Tracker queue';
   }
}
