import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { narrowDecorator, outlineDecorator } from '../../../_storybook';
import { SuggestLayer } from '../../models';

import { AbcServiceItem } from './AbcServiceItem';
import { IAbcService } from './models';

storiesOf('suggestions/AbcServiceItem', module)
   .addDecorator(outlineDecorator)
   .addDecorator(narrowDecorator)
   .add('regular', () => {
      const item: IAbcService = {
         title: 'Infra cloud',
         url: 'https://abc.yandex-team.ru/services/runtimecloud',
         id: 1172,
         layer: SuggestLayer.Services,
         click_urls: [
            '//clck.yandex.ru/click/dtype=SAAS/p=0/saas_url=https%3A%2F%2Fabc.yandex-team.ru%2Fservices%2Fruntimecloud/robot=0/r=%25D0%2598%25D0%25BD%25D1%2584%25D1%2580%25D0%25B0%25D1%2581%25D1%2582%25D1%2580%25D1%2583%25D0%25BA%25D1%2582%25D1%2583%25D1%2580%25D0%25BD%25D0%25BE%25D0%25B5%2B%25D0%25BE%25D0%25B1%25D0%25BB%25D0%25B0%25D0%25BA%25D0%25BE%252A/service=intrasearch-plan/kps=77306/uid=is1120000000112960/yandexuid=is1120000000112960/reqid=1591894533809163-18207748760475882068-vla1-0266-vla-saas-mmeta-17000-SAAS/raId=C2062C04FD169C56/slots=242148,0,20/how=rlv/*data=url%3Dhttps%3A%2F%2Fabc.yandex-team.ru%2Fservices%2Fruntimecloud',
         ],
         slug: 'runtimecloud',
         status: 'develop',
         owner: {
            login: 'bkht',
            first_name: 'Victor',
            last_name: 'Bukhtoyarov',
         },
      };

      return <AbcServiceItem item={item} />;
   })
   .add('closed', () => {
      const item: IAbcService = {
         title: 'Y.Deploy Beta-Testing',
         url: 'https://abc.yandex-team.ru/services/ydeploybetatesting',
         id: 4298,
         layer: SuggestLayer.Services,
         click_urls: [
            '//clck.yandex.ru/click/dtype=SAAS/p=2/saas_url=https%3A%2F%2Fabc.yandex-team.ru%2Fservices%2Fydeploybetatesting/robot=0/r=%25D0%25B4%25D0%25B5%25D0%25BF%25D0%25BB%25D0%25BE%25D0%25B9%252A/service=intrasearch-plan/kps=77306/uid=is1120000000112960/yandexuid=is1120000000112960/reqid=1591894439123789-5498581257676075391-vla1-0701-vla-saas-mmeta-17000-SAAS/raId=B4F480417E1E1963/slots=242148,0,20/how=rlv/*data=url%3Dhttps%3A%2F%2Fabc.yandex-team.ru%2Fservices%2Fydeploybetatesting',
         ],
         slug: 'ydeploybetatesting',
         status: 'closed',
         owner: {
            login: 'dmitriyt',
            first_name: 'Dmitriy',
            last_name: 'Tarabanko',
         },
      };

      return <AbcServiceItem item={item} />;
   });
