import * as React from 'react';

import { classNames } from '../../../formatters';
import { AccentFirstLetter } from '../../../small_components';

import classes from './AbcServiceItem.module.css';
import { IAbcService } from './models';

interface IProps {
   item: IAbcService;
}

export const AbcServiceItem = React.memo(({ item }: IProps) => {
   return (
      <div
         className={classNames(classes.item, {
            [classes.closed]: item.status === 'closed',
         })}
      >
         <div className={classes.info}>
            <div>
               <AccentFirstLetter value={item.title} />
               {item.status === 'closed' ? <span className={classes.status}>({item.status})</span> : null}
            </div>
            <div>
               <span className={classes.id}>Id: {item.id}, </span>
               <span className={classes.slug}>{item.slug}</span>
            </div>
         </div>
      </div>
   );
});

AbcServiceItem.displayName = 'AbcServiceItem';
