import * as React from 'react';
import { Observable } from 'rxjs';

import { suggestApi } from '../../api';
import { ISuggestStrategy } from '../models';

import { AbcServiceItem } from './AbcServiceItem';
import { IAbcService } from './models';

export class AbcServiceStrategy implements ISuggestStrategy {
   public avoidAddingPaddings = true;

   public load(query: string): Observable<IAbcService[]> {
      return suggestApi.findAbcServices(query.replace(/^@/, ''));
   }

   public renderItem(entity: IAbcService): JSX.Element {
      return <AbcServiceItem item={entity} />;
   }

   public getQueryFromEntity(entity: IAbcService): string {
      return entity ? entity.title : '';
   }

   public getPlaceholder(): string {
      return 'Service name';
   }
}
