import { SuggestLayer } from '../models';

import { StaffGroupStrategy } from './groups/strategy';
import { IssuesStrategy } from './issues/strategy';
import { ISuggestStrategy } from './models';
import { StaffStrategy } from './people/strategy';
import { StaffPeopleOrGroupStrategy } from './peopleOrGroup/strategy';
import { QueuesStrategy } from './queues/strategy';
import { AbcServiceStrategy } from './services/strategy';
import { UnknownStrategy } from './unknown/strategy';

export function getStrategy(layer: SuggestLayer | string): ISuggestStrategy {
   switch (layer) {
      case SuggestLayer.Services:
         return new AbcServiceStrategy();
      case SuggestLayer.Groups:
         return new StaffGroupStrategy();
      case SuggestLayer.Issues:
         return new IssuesStrategy();
      case SuggestLayer.People:
         return new StaffStrategy();
      case SuggestLayer.PeopleOrGroups:
         return new StaffPeopleOrGroupStrategy();
      case SuggestLayer.Queues:
         return new QueuesStrategy();
      default:
         return new UnknownStrategy();
   }
}
