import * as React from 'react';
import { Observable, of } from 'rxjs';

import { ISuggestBaseEntity } from '../../models';
import { ISuggestStrategy } from '../models';

export class UnknownStrategy implements ISuggestStrategy {
   // eslint-disable-next-line @typescript-eslint/no-unused-vars
   public load(query: string): Observable<ISuggestBaseEntity[]> {
      return of([]);
   }

   public renderItem(entity: ISuggestBaseEntity): JSX.Element {
      return <div>{entity.title}</div>;
   }

   public getQueryFromEntity(entity: ISuggestBaseEntity): string {
      return entity ? `${entity.id}` : '';
   }

   public getPlaceholder(): string {
      return 'Query';
   }
}
