/**
 * https://wiki.yandex-team.ru/intranetpoisk/suggest/api/
 */

export type SuggestLanguage = 'en' | 'ru';

export type EntityId = string | number | null;

export enum SuggestLayer {
   Groups = 'groups',
   Issues = 'issues',
   People = 'people',
   PeopleOrGroups = 'people,groups',
   Queues = 'queues',
   Services = 'services',
}

export interface ISuggestBaseParams {
   allow_empty?: boolean;
   language: SuggestLanguage;
   layers: SuggestLayer;
   text: string;
   version: number;
}

export interface ISuggestLayerBaseParams {
   /**
    * По-умолчанию 0
    */
   page?: number;
   /**
    * По-умолчанию 5
    */
   per_page?: number;
   /**
    * Запрос для фильтрации документов в выдаче в виде:
    * <название атрибута>:"<значение>" .
    * Для фильтрации по нескольким атрибутам, они комбинируются через &.
    * Например,  s_system:"idm"&s_slug_path:"/common/*" .
    * У каждого слоя свои поисковые атрибуты.
    */
   query?: string;
}

interface IPagination {
   page: number;
   pages: number;
   per_page: number;
}

export interface ISuggestBaseEntity {
   click_urls?: string[];
   id: string | number;
   layer: SuggestLayer | string;
   title: string;
   url: string;
}

export interface ISuggestLayerResponse<T extends ISuggestBaseEntity> {
   pagination: IPagination;
   result: T[];
}

export interface ISuggestResponse {
   [layer: string]: ISuggestLayerResponse<ISuggestBaseEntity>;
}

export interface ISuggestErrorResponse {
   details: string[];

   /**
    * @see https://wiki.yandex-team.ru/IntranetPoisk/Dev/Abovemeta/errors/#oshibki
    */
   error_code: number;

   error_message: string;
}
