import { Meta } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useCallback, useState } from 'react';

import { FieldLayout, FormFieldType, FormLayout, IFieldProps, IFormField } from '../forms';

import { ISuggestBaseEntity, SuggestLayer } from './models';
import { SuggestSelect } from './SuggestSelect';

interface Props extends IFieldProps<string> {
   onChange(e: SyntheticEvent | null, v: string | null): void;
}

function PeopleField(props: Props) {
   const onSelect = useCallback(
      (e: SyntheticEvent, item: ISuggestBaseEntity | null) => props.onChange(e, item ? (item.id as string) : null),
      [props],
   );

   return (
      <FieldLayout config={props.config} help={props.help} error={props.error}>
         <SuggestSelect
            layer={SuggestLayer.People}
            onSelect={onSelect}
            clearOnSelect={false}
            disabled={props.disabled}
         />
      </FieldLayout>
   );
}

const initialValue = { x: null as string | null };
type Value = typeof initialValue;

const fields: IFormField<Value>[] = [
   {
      component: PeopleField,
      label: 'People',
      name: 'x',
      type: FormFieldType.Custom,
   },
];

function FormStory() {
   const [value, setValue] = useState(initialValue);

   const update = useCallback((e: SyntheticEvent | null, v: Value) => {
      setValue(v);
   }, []);

   return <FormLayout onChange={update} fields={fields} value={value} />;
}

export const Form = () => <FormStory />;

export default {
   title: 'suggestions/SuggestSelect/usage',
} as Meta;
