import { getSuggestions } from './utils';

describe('suggestions/utils', () => {
   describe('getSuggestions', () => {
      const items = [
         { id: 1, name: 'xx' },
         { id: 2, name: 'yy' },
         { id: 3, name: 'zzx' },
         { id: 4, name: 'yxz' },
      ];

      it('smoke test', () => {
         expect(
            getSuggestions(
               items,
               i => i.name.includes('x'),
               2,
               i => ({ id: i.id, title: i.name }),
            ),
         ).toEqual([
            { id: 1, title: 'xx' },
            { id: 3, title: 'zzx' },
         ]);

         expect(
            getSuggestions(
               items,
               i => i.name.includes('x'),
               1, // changed here
               i => ({ id: i.id, title: i.name }),
            ),
         ).toEqual([{ id: 1, title: 'xx' }]);
      });
   });
});
