import { Meta } from '@storybook/react';
import { Button } from '@yandex-cloud/uikit';
import * as React from 'react';

import { styleHelpers } from '../_styles/styleHelpers';
import { autobind } from '../utils';

import { toasts } from './toasts';

class ToastStories extends React.PureComponent {
   private count = 0;

   private fishText =
      'Making content the central approach to a major branding touch point ' +
      'represents the unification of two very different schools of marketing.';

   public render() {
      return (
         <>
            <section>
               <h3>simple</h3>
               <article>
                  <Button onClick={this.onInfo}>info</Button>
                  <Button onClick={this.onSuccess}>success</Button>
                  <Button onClick={this.onError}>error</Button>
               </article>
            </section>

            <section>
               <h3>handleApiError</h3>
               <article>
                  <Button onClick={this.onApiError}>apiError</Button>
               </article>
            </section>

            <section>
               <h3>with custom content</h3>
               <article>
                  <Button onClick={this.onWithContent}>with content</Button>
               </article>
            </section>
         </>
      );
   }

   @autobind
   private onApiError() {
      const handler = toasts.handleApiError('Host loading');
      handler('request timeout');
   }

   @autobind
   private onError() {
      toasts.error(this.fishText, `Message title ${this.count}`);
      this.count += 1;
   }

   @autobind
   private onInfo() {
      toasts.info(this.fishText, `Message title ${this.count}`);
      this.count += 1;
   }

   @autobind
   private onSuccess() {
      toasts.success(this.fishText, `Message title ${this.count}`);
      this.count += 1;
   }

   @autobind
   private onWithContent() {
      const content = (
         <>
            This is custom content:
            <Button view={'action'} className={styleHelpers.spaces}>
               ok
            </Button>
            <Button>cancel</Button>
         </>
      );

      toasts.success(this.fishText, 'Confirmation', content);
   }
}

export const All = () => <ToastStories />;

export default {
   title: 'other/toasts',
} as Meta;
