import { Toaster } from '@yandex-cloud/uikit';
import { ReactNode } from 'react';

import { IApiError, parseApiError } from '../http';

import { ToastOptions } from './models';

class Toasts {
   private lastId = 0;

   private toaster = new Toaster();

   public info(text: string, title?: string, content?: JSX.Element): unknown {
      return this.show(undefined, text, title, content);
   }

   public success(text: string, title?: string, content?: JSX.Element): unknown {
      return this.show('success', text, title, content);
   }

   public error(text: string, title?: string, content?: JSX.Element): unknown {
      return this.show('error', text, title, content);
   }

   public apiError(action: string, error: string | IApiError) {
      return this.error(parseApiError(error), `${action} API error:`);
   }

   public handleApiError(action: string): (error: string | IApiError) => unknown {
      return (error: string | IApiError) => this.apiError(action, error);
   }

   public createToast(options: ToastOptions) {
      return this.toaster.createToast(options);
   }

   private show(type: ToastOptions['type'], text: string, title?: string, content?: ReactNode) {
      this.lastId += 1;

      return this.createToast({
         content: content ?? text,
         name: `${type}_${this.lastId}`,
         title: title ?? '',
         type,
      });
   }
}

export const toasts = new Toasts();
