import { ReducerAction, ReducerState } from 'react';

export const logActions = <R extends (s: any, a: any) => any>(reducer: R): R => {
   const wrapper = (prevState: ReducerState<R>, action: ReducerAction<R>) => {
      const state = reducer(prevState, action);

      console.group(`action ${(action as any).type}:`);
      console.log('Before', prevState);
      console.log('Action', action);
      console.log('After', state);
      console.groupEnd();

      return state;
   };

   return wrapper as any; // TODO разобраться с типами
};
