import * as React from 'react';
import { Redirect, Route, RouteComponentProps, RouteProps, Switch } from 'react-router';

export type AppRoute = RouteProps & { name?: string };

export function createRedirect(path: string) {
   return function RedirectScreen(props: RouteComponentProps) {
      const urlParams = Object.keys(props.match.params);

      let to = path;
      for (const param of urlParams) {
         to = to.replace(`:${param}`, props.match.params[param]);
      }

      return <Redirect to={to} />;
   };
}

export function createRouteRegisterComponent(routeConfigs: AppRoute[]) {
   return function RoutesComponent() {
      const routes = routeConfigs.map(r => <Route key={(r.path as string) || '404'} {...r} />);

      return <Switch>{routes}</Switch>;
   };
}
