import * as React from 'react';
import { Observable } from 'rxjs';

import { useDismounted } from '../react_hooks';

export interface IDismountedProps {
   dismounted?: Observable<void>;
}

/**
 * @deprecated Используй useDismounted
 */
export function withDismounted<P extends IDismountedProps>(Child: React.ComponentType<P>): React.FC<P> {
   const ComponentWithDismountedProps = (props: P) => {
      const dismounted = useDismounted();

      return React.createElement(Child, { ...props, dismounted });
   };

   ComponentWithDismountedProps.displayName = Child.displayName || Child.name || 'Component';

   return ComponentWithDismountedProps;
}
