import type { StorybookConfig } from '@storybook/core-common';

import { addMonacoYaml } from '../src/services/addMonacoYaml';
import MonacoWebpackPlugin from 'monaco-editor-webpack-plugin';

const configuredMonaco = new MonacoWebpackPlugin({
    languages: [],
    features: [],
    customLanguages: [addMonacoYaml()],
});

const config: StorybookConfig = {
    stories: ['../src/**/*.stories.mdx', '../src/**/*.stories.@(js|jsx|ts|tsx)'],
    addons: ['@storybook/addon-links', '@storybook/addon-essentials', '@storybook/addon-knobs'],
    typescript: {
        check: false,
        checkOptions: {},
        reactDocgen: 'react-docgen-typescript',
        reactDocgenTypescriptOptions: {
            setDisplayName: false,
            shouldExtractLiteralValuesFromEnum: true,
            compilerOptions: {
                allowSyntheticDefaultImports: true,
                esModuleInterop: true,
            },
        },
    },
    core: {
        builder: 'webpack5',
    },
    framework: '@storybook/react',
    webpackFinal: async (config, { configType }) => {
        config.plugins?.push(configuredMonaco);
        return config;
    },
};

export default config;

export const core = {
    builder: 'webpack5',
};
