import { withKnobs } from "@storybook/addon-knobs";
import { configure, Lang } from "@yandex-cloud/uikit";
import "@yandex-cloud/uikit/styles/styles.css";
import { CommonProvider, configure as commonConfigure, Lang as CommonLang } from "@yandex-data-ui/common";

import "@yandex-data-ui/common/build/styles/styles.css";
import "./storybook.css";

// Common library i18n
configure({ lang: Lang.En }); // for uikit
commonConfigure({ lang: CommonLang.En }); // for common

const withCommonProvider = (Story, context) => (
    <CommonProvider mobile={false} theme={"light"}>
        <Story {...context} />
    </CommonProvider>
);

export const decorators = [withKnobs({ timestamps: true }), withCommonProvider];

export const parameters = {
    actions: { argTypesRegex: "^on[A-Z].*" },
    controls: {
        matchers: {
            color: /(background|color)$/i,
            date: /Date$/
        }
    },
    options: {
        storySort: (a, b) =>
            a[1].kind === b[1].kind ? 0 : a[1].id.localeCompare(b[1].id, undefined, { numeric: true })
    }
};
