const { writeFileSync, mkdirSync } = require('fs');
const { resolve, dirname } = require('path');

const { TARGET, COLORS_SERVICE } = process.env;

if (!TARGET) {
    throw new Error('TARGET env is needed');
}

if (!COLORS_SERVICE) {
    throw new Error('COLORS_SERVICE env is needed');
}

const targetDir = dirname(TARGET);

try {
    mkdirSync(targetDir);
} catch (e) {
    console.log(`${targetDir} already exists`);
}

const colorsServicePath = resolve(COLORS_SERVICE);
const { colorsRootCss } = require(colorsServicePath);

const targetPath = resolve(TARGET);
writeFileSync(targetPath, colorsRootCss);
console.log(`${TARGET} was wrote`);
