const { execSync } = require('child_process');
const { writeFileSync, readFileSync } = require('fs');

const rootDir = '.';
const packagePath = `${rootDir}/package.json`;

const packageText = readFileSync(packagePath).toString();

const packageJson = JSON.parse(packageText);

// postinstall необходимо удалить, так как patch-package не будет работать, когда сам пакет находится в зависимостях
delete packageJson.scripts.postinstall;

// просто не нужны для использования
delete packageJson.devDependencies;

try {
    // записываем изменённый файл
    writeFileSync(packagePath, JSON.stringify(packageJson, null, 4));

    // публикуем пакет
    execSync('npm publish').toString();
} catch (e) {
    console.log(e);
} finally {
    // возвращаем обратно
    writeFileSync(packagePath, packageText);
}
