import { Skeleton } from '@yandex-infracloud-ui/libs';
import React, { Suspense } from 'react';

import type { MonacoEditorProps } from '../../models';

const MonacoEditor = React.lazy(() => import('./MonacoEditor'));

export function LazyMonacoEditor(props: MonacoEditorProps) {
    const { forwardedRef, ...otherProps } = props;

    return (
        <Suspense fallback={<Skeleton items={[{ size: 44, space: 0, width: '100%' }]} />}>
            <MonacoEditor {...otherProps} ref={forwardedRef} />
        </Suspense>
    );
}

LazyMonacoEditor.displayName = 'LazyMonacoEditor';
