import { Meta, Story } from '@storybook/react';
import { TextInput } from '@yandex-cloud/uikit';
import React, { useRef, useState } from 'react';
import type { EditorRef, MonacoEditorProps } from '../../../models';

import { MonacoEditor } from '../MonacoEditor';

const Template: Story<MonacoEditorProps> = props => {
    const [value, setValue] = useState(props.value);
    const editorRef = useRef<EditorRef | null>(null);

    return (
        <>
            <h3>html area</h3>
            <TextInput value={value} multiline={true} placeholder={'Placeholder'} onUpdate={setValue} />
            <h3>monaco editor</h3>
            <MonacoEditor
                ref={editorRef}
                value={value}
                onUpdate={setValue}
                placeholder={'Placeholder'}
                isAutoRows={false}
                maxRows={15}
                options={props.options}
            />
        </>
    );
};

export const Default = Template.bind({});
Default.args = { value: 'key1=value1, "value2 with a=b lines"; key2!=value3;' };

export const Empty = Template.bind({});
Empty.args = { value: '' };

export const Javascript = Template.bind({});
Javascript.args = {
    value: `var myWorker = new Worker('/worker.js');
var first = document.querySelector('input#number1');
var second = document.querySelector('input#number2');

first.onchange = function() {
    myWorker.postMessage([first.value, second.value]);
    console.log('Message posted to worker');
}`,
    options: { language: 'javascript' },
};

export const Typescript = Template.bind({});
Typescript.args = {
    value: `type GetReturnType<Type> = Type extends (...args: never[]) => infer Return
    ? Return
    : never;

type Num = GetReturnType<() => number>;

type Str = GetReturnType<(x: string) => string>;

type Bools = GetReturnType<(a: boolean, b: boolean) => boolean[]>;`,
    options: { language: 'typescript' },
};

export default {
    title: 'MonacoEditor',
} as Meta;
