import { Popover } from '@yandex-cloud/uikit';
import React, { RefObject } from 'react';

import { useStatusDataByEditorRef } from '../../hooks';
import { EditorRef, MonacoEditorValidationInfo } from '../../models';
import { MonacoEditorMessageBlock, MonacoEditorValidationSummary } from './components';

import classes from './MonacoEditorStatusLine.module.css';

export type StatusLineFeature = 'messages';

interface Props {
    editorRef?: RefObject<EditorRef>;
    validationInfo?: MonacoEditorValidationInfo | null;
}

export const MonacoEditorStatusLine: React.FC<Props> = React.memo(
    ({ validationInfo: customValidationInfo, editorRef }) => {
        const { validationInfo: currentValidationInfo } = useStatusDataByEditorRef({ editorRef });
        const validationInfo = currentValidationInfo ?? customValidationInfo;
        return (
            <div className={classes.statusLine}>
                <div className={classes.statusLineArea}>
                    {validationInfo && (
                        <div className={classes.tile}>
                            <Popover
                                openOnHover={false}
                                content={
                                    <div className={classes.largeBlock}>
                                        <div className={classes.messageList}>
                                            {validationInfo.messages.map((message, i) => (
                                                <MonacoEditorMessageBlock message={message} key={String(i)} />
                                            ))}
                                        </div>
                                    </div>
                                }
                                placement={['top']}
                            >
                                <MonacoEditorValidationSummary summary={validationInfo.summary} />
                            </Popover>
                        </div>
                    )}
                </div>
                <div className={classes.space}></div>
                <div className={classes.statusLineArea}></div>
            </div>
        );
    },
);

MonacoEditorStatusLine.displayName = 'MonacoEditorStatusLine';
