import React from 'react';

import { getPrettyMessageText, MonacoEditorMessage } from '../../../../models';
import { messageColors } from '../../colors';

import classes from './MonacoEditorMessageBlock.module.css';

interface Props {
    message: MonacoEditorMessage;
}

export const MonacoEditorMessageBlock: React.FC<Props> = React.memo(({ message }) => {
    const text = getPrettyMessageText({ message });
    const { status } = message;

    return (
        <div className={classes.message} style={{ borderColor: messageColors[status] ?? 'inherit' }}>
            {text}
        </div>
    );
});

MonacoEditorMessageBlock.displayName = 'MonacoEditorMessageBlock';
