import React from 'react';

import type { MonacoEditorMessageStatus, MonacoEditorMessageSummary } from '../../../../models';
import { pluralNumber } from '../../../../utils';
import { messageColors } from '../../colors';

import classes from './MonacoEditorValidationSummary.module.css';

interface Props {
    summary: MonacoEditorMessageSummary;
}

export const MonacoEditorValidationSummary: React.FC<Props> = React.memo(({ summary }) => {
    const { countByStatus } = summary;

    const visibleCount = Object.entries(countByStatus).filter(record => record[1] > 0);

    return (
        <div className={classes.summary}>
            {visibleCount.map(([type, count]) => (
                <span key={type} style={{ color: messageColors[type as MonacoEditorMessageStatus] ?? 'inherit' }}>
                    {pluralNumber(count, type, `${type}s`)}
                </span>
            ))}
        </div>
    );
});

MonacoEditorValidationSummary.displayName = 'MonacoEditorValidationSummary';
