export const stageSchema = {
    '$schema': 'http://json-schema.org/draft-04/schema#',
    '$ref': '#/definitions/TStage',
    'definitions': {
        'NInfra.NPodAgent.API.LiteralEnvSelector': {
            'properties': {
                'value': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Literal Env Selector',
        },
        'NInfra.NPodAgent.API.SecretSelector': {
            'properties': {
                'alias': {
                    'type': 'string',
                },
                'id': {
                    'type': 'string',
                },
                'decode_base64': {
                    'type': 'boolean',
                    'description':
                        'Если этот флаг выставлен, то значение секрета будет base64 декодированно Этот флаг нужен поскольку секретница кодирует содержимое секретов-файлов в base64 Более подробно в DEPLOY-1336',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Secret Selector',
            'description':
                'Alias - имя (ключ в мапе) секрета в \u003cpod\u003e/spec/secrets (и TPodAgentRequest.Secrets) Id - ключ в yav секрете В момент обработки спеки будет добавлена переменная окружения с значением равным value yav секрета',
        },
        'NInfra.NPodAgent.API.TBox': {
            'properties': {
                'id': {
                    'type': 'string',
                    'description':
                        "Уникальное имя box (в рамках pod'а). Должно состоять только из символов, разрешенных в имени porto контейнера. (a..z, A..Z, 0..9, _-@:.)",
                },
                'rootfs': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TRootfsVolume',
                    'additionalProperties': true,
                },
                'volumes': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TMountedVolume',
                    },
                    'type': 'array',
                    'description':
                        'Валидация: mount_point не пересекается со static_resource Валидация: все mount_point различны',
                },
                'init': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TUtilityContainer',
                    },
                    'type': 'array',
                    'description': 'Процессы, запускаемые при подготовке Box после создания вольюмов',
                },
                'static_resources': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TMountedStaticResource',
                    },
                    'type': 'array',
                    'description':
                        'Валидация: mount_point не пересекается с volume Валидация: все mount_point различны',
                },
                'bind_skynet': {
                    'type': 'boolean',
                    'description':
                        "Если указано true pod agent создает bind volume из \u003cpod_chroot\u003e/place/berkanavt/supervisor в \u003cbox_chroot\u003e/place/berkanavt/supervisor На файловой системе box'а обязательно наличие директории /place/berkanavt/supervisor и следующих симлинков (без них скачивание/раздача работать не будут совсем):   /skynet =\u003e /Berkanavt/supervisor/base/active   /usr/local/bin/sky =\u003e /skynet/tools/sky   /Berkanavt =\u003e /place/berkanavt Эти директории и симлинки можно добавить с помощью небольшого слоя sbr:922226367 PS Если вы используете расширенные базовые образы, нужные симлинки в них уже есть https://wiki.yandex-team.ru/runtime-cloud/virtualimages/#rasshirennyjjobraz",
                },
                'compute_resources': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TComputeResources',
                    'additionalProperties': true,
                    'title':
                        'Если в аннотациях пода есть флаг: pod.rbind.basesearch: true\n То pod_agent создает bind volume из \u003cpod_chroot\u003e/basesearch в \u003cbox_chroot\u003e/basesearch',
                    'description':
                        'Если в аннотациях пода есть флаг: pod.rbind.yt: true То pod_agent создает bind volume из \u003cpod_chroot\u003e/yt в \u003cbox_chroot\u003e/yt  Если в аннотациях пода есть флаг: pod.rbind.basesearch: true То pod_agent создает bind volume из \u003cpod_chroot\u003e/basesearch в \u003cbox_chroot\u003e/basesearch  Ограничения на meta контейнер Box',
                },
                'resolv_conf': {
                    'enum': ['EResolvConf_DEFAULT', 'EResolvConf_KEEP', 'EResolvConf_NAT64', 'EResolvConf_NAT64_LOCAL'],
                    'type': 'string',
                    'title': 'E Resolv Conf',
                },
                'env': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TEnvVar',
                    },
                    'type': 'array',
                    'description':
                        'Переменные окружения - прокидываются во все init контейнеры бокса, meta контейнер бокса и во все вложенные workload При этом, если переменная окружения указана и в box env, и в workload env, то будет выбрано значение из workload env',
                },
                'virtual_disk_id_ref': {
                    'type': 'string',
                    'description':
                        'Virtual disk, где будет расположен box Rootfs volume будет создан в place, находящемся на этом виртуальном диске Валидация: должен совпадать с virtual_disk_id_ref у слоев и ресурсов, из которых собирается box',
                },
                'specific_type': {
                    'type': 'string',
                    'description':
                        'Тип бокса Должен иметь значение "default", "system" или одно из значений в списке TProjectSpec.user_specific_box_types',
                },
                'isolation_mode': {
                    'enum': ['EContainerIsolationMode_NO_ISOLATION', 'EContainerIsolationMode_CHILD_ONLY'],
                    'type': 'string',
                    'title': 'E Container Isolation Mode',
                },
                'cgroup_fs_mount_mode': {
                    'enum': ['ECgroupFsMountMode_NONE', 'ECgroupFsMountMode_RO', 'ECgroupFsMountMode_RW'],
                    'type': 'string',
                    'title': 'E Cgroup Fs Mount Mode',
                    'description': 'Определяет, нужно ли монтирование fs cgroup в бокс и с какими правами',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Box',
            'description':
                "Обеспечивает изоляцию по диску и pidns Сеть между боксами не изолирована - workload'ы разных боксов могут общаться друг с другом по localhost",
        },
        'NInfra.NPodAgent.API.TCacheLayer': {
            'properties': {
                'revision': {
                    'type': 'integer',
                    'description': 'Ревизия кэш слоя',
                },
                'layer': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TLayer',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Cache Layer',
        },
        'NInfra.NPodAgent.API.TCacheResource': {
            'properties': {
                'revision': {
                    'type': 'integer',
                    'description': 'Ревизия кэш ресурса',
                },
                'resource': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TResource',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Cache Resource',
        },
        'NInfra.NPodAgent.API.TComputeResources': {
            'properties': {
                'vcpu_guarantee': {
                    'type': 'integer',
                    'description':
                        'Ограничения по CPU, в виртуальных миллиядрах (vcpu). Тем самым, заказав vcpu = 1000, мы получим одно виртуальное ядро.',
                },
                'vcpu_limit': {
                    'type': 'integer',
                },
                'cpu_policy': {
                    'enum': [
                        'ECpuPolicy_UNKNOWN',
                        'ECpuPolicy_NORMAL',
                        'ECpuPolicy_HIGH',
                        'ECpuPolicy_BATCH',
                        'ECpuPolicy_IDLE',
                        'ECpuPolicy_ISO',
                    ],
                    'type': 'string',
                    'title': 'E Cpu Policy',
                    'description': '"rt" cpu policy is forbidden: DEPLOY-2046',
                },
                'cpu_weight': {
                    'type': 'number',
                },
                'memory_guarantee': {
                    'type': 'integer',
                    'description': 'Ограничения по памяти, в байтах',
                },
                'memory_limit': {
                    'type': 'integer',
                },
                'anonymous_memory_limit': {
                    'type': 'integer',
                },
                'recharge_on_pgfault': {
                    'type': 'boolean',
                    'description': 'Если true иммигрирует кэш при незначительной ошибке страницы, по умолчанию: false.',
                },
                'thread_limit': {
                    'type': 'integer',
                },
                'io_limit': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TIoLimit',
                    },
                    'type': 'array',
                    'title': 'Параметры IO',
                    'description': 'Параметры IO  Лимит на чтение/запись в байтах в секунду',
                },
                'io_ops_limit': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TIoLimit',
                    },
                    'type': 'array',
                    'description': 'Лимит iops (input/output operations per second)',
                },
                'io_policy': {
                    'enum': [
                        'EIoPolicy_UNKNOWN',
                        'EIoPolicy_NONE',
                        'EIoPolicy_NORMAL',
                        'EIoPolicy_HIGH',
                        'EIoPolicy_BATCH',
                        'EIoPolicy_IDLE',
                    ],
                    'type': 'string',
                    'title': 'E Io Policy',
                    'description': '"rt" io policy is forbidden: DEPLOY-2285',
                },
                'io_weight': {
                    'type': 'number',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Compute Resources',
        },
        'NInfra.NPodAgent.API.TDestroyPolicy': {
            'properties': {
                'container': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TUtilityContainer',
                    'additionalProperties': true,
                },
                'http_get': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.THttpGet',
                    'additionalProperties': true,
                },
                'max_tries': {
                    'type': 'integer',
                    'description':
                        'Количестно попыток выполнить gracefully destroy перед тем, как полностью удалить start контейнер workload Валидация: должно быть \u003e 0',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Destroy Policy',
            'description':
                'При удалении workload из спеки будет вызван destroy hook, который выпонится только после окончания выполнения stop hook и перехода start контейнера в состояние dead. Destroy hook будет будет перезапускаться до того момента, пока хоть раз не выполнится успешно, или не провалится max_tries раз',
        },
        'NInfra.NPodAgent.API.TEnvVar': {
            'properties': {
                'name': {
                    'type': 'string',
                },
                'value': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TEnvVarValue',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Env Var',
        },
        'NInfra.NPodAgent.API.TEnvVarValue': {
            'properties': {
                'secret_env': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.SecretSelector',
                    'additionalProperties': true,
                },
                'literal_env': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.LiteralEnvSelector',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Env Var Value',
        },
        'NInfra.NPodAgent.API.TFile': {
            'properties': {
                'file_name': {
                    'type': 'string',
                    'description': 'Имя файла Валидация: не содержит "/"',
                },
                'raw_data': {
                    'type': 'string',
                    'description': 'Содержимое этой строки будет скопировано в файл',
                },
                'secret_data': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.SecretSelector',
                    'additionalProperties': true,
                    'description': 'Cодержимое секрета будет скопировано в файл',
                },
                'multi_secret_data': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TMultiSecretFileContent',
                    'additionalProperties': true,
                    'description':
                        'Файл со всеми полями из одного секрета Вывод похож на ya vault get version, только без дополнительной информации (Файл будет содержать только "value")',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T File',
        },
        'NInfra.NPodAgent.API.TFileStorage': {
            'properties': {
                'quota_bytes': {
                    'type': 'integer',
                    'description':
                        'Квота на размер Поле не обрабатывается - porto не умеет во вложенные квоты по диску',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T File Storage',
        },
        'NInfra.NPodAgent.API.TFiles': {
            'properties': {
                'files': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TFile',
                    },
                    'type': 'array',
                    'description': 'Валидация: все имена файлов различны',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Files',
        },
        'NInfra.NPodAgent.API.TGenericVolume': {
            'properties': {
                'quota_bytes': {
                    'type': 'integer',
                    'description':
                        'Квота на размер Поле не обрабатывается - porto не умеет во вложенные квоты по диску',
                },
                'layer_refs': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description':
                        'Слои, из которых собирается volume Как и в porto, слои идут в порядке top-layer;...;bottom-layer Валидация: ids в списке должны быть уникальные',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Generic Volume',
        },
        'NInfra.NPodAgent.API.TGroupId': {
            'properties': {
                'value': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Group Id',
        },
        'NInfra.NPodAgent.API.THttpGet': {
            'properties': {
                'port': {
                    'type': 'integer',
                },
                'path': {
                    'type': 'string',
                    'description':
                        'Путь к ручке, например: "/ping" Если путь пустой, то будет интерпретироваться как "/" из-за особенностей http клиента',
                },
                'expected_answer': {
                    'type': 'string',
                    'description': 'В случае несовпадения ответа http запрос считается неуспешным',
                },
                'any': {
                    'type': 'boolean',
                    'description': 'Если выставлено в true, ответ сервера игнорируется (проверяется только код ответа)',
                },
                'time_limit': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TTimeLimit',
                    'additionalProperties': true,
                    'description': '@see TTimeLimit',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Http Get',
            'description': 'Успешными кодами ответов считаются те, что лежат в полуинтервале [200, 300)',
        },
        'NInfra.NPodAgent.API.TIoLimit': {
            'properties': {
                'raw': {
                    'type': 'string',
                    'description':
                        'Файловая система или путь до файла или путь до диска (fs|\u003cpath\u003e|\u003cdisk\u003e) Данная строчка будет передана в porto as is Чтобы указать девайс, укажите его название без префикса /dev/ Чтобы указать путь относительно корня dom0 машины, укажите его с "/" в начале Чтобы указать путь относительно chroot контейнера, укажите его с "./" в начале',
                },
                'default_target': {
                    'enum': ['EDefaultIoLimitTarget_NONE', 'EDefaultIoLimitTarget_PLACE', 'EDefaultIoLimitTarget_SSD'],
                    'type': 'string',
                    'title': 'E Default Io Limit Target',
                },
                'virtual_disk_id_ref': {
                    'type': 'string',
                    'description': 'Virtual disk, на который в целом будет наложен лимит',
                },
                'type': {
                    'enum': ['EIoLimitType_READ', 'EIoLimitType_WRITE'],
                    'type': 'string',
                    'title': 'E Io Limit Type',
                },
                'value': {
                    'type': 'integer',
                    'description': 'Величина лимита',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Io Limit',
        },
        'NInfra.NPodAgent.API.TLayer': {
            'properties': {
                'id': {
                    'type': 'string',
                    'description':
                        "Уникальное имя слоя (в рамках pod'а). Должно состоять только из символов, разрешенных в имени porto контейнера. (a..z, A..Z, 0..9, _-@:.)",
                },
                'meta': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TResourceMeta',
                    'additionalProperties': true,
                    'description':
                        'Не нужно для Pod-agent Мета информация о ресурсе, необходимо для интеграции с CI/CD',
                },
                'checksum': {
                    'type': 'string',
                    'description':
                        'Контрольная сумма, формат \u003cсхема\u003e:\u003cзначение\u003e Поддерживаемые схемы "MD5:", "EMPTY:", "SHA256:" - case sensitive',
                },
                'url': {
                    'type': 'string',
                    'description':
                        'URL для скачивания, протоколы: http, https, rbtorrent Для записи строчки в файл URL должен быть равен "raw:\u003cстрока\u003e" Только для тестов: можно указать путь к файлу на хосте "local:\u003cfilepath\u003e"',
                },
                'sky_get': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TSkyGetDownload',
                    'additionalProperties': true,
                    'description': 'Вызов sky get с особыми параметрами',
                },
                'virtual_disk_id_ref': {
                    'type': 'string',
                    'description':
                        'Virtual disk, где будет расположен layer Слой будт скачан на porto volume, созданный на этом диске и импортирован в porto Place, в который импортирован данный слой, лежит на этом же диске Валидация: должен совпадать с virtual_disk_id_ref у volume, box, которые используют этот слой',
                },
                'layer_source_file_storage_policy': {
                    'enum': [
                        'ELayerSourceFileStoragePolicy_NONE',
                        'ELayerSourceFileStoragePolicy_KEEP',
                        'ELayerSourceFileStoragePolicy_REMOVE',
                    ],
                    'type': 'string',
                    'title': 'E Layer Source File Storage Policy',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Layer',
        },
        'NInfra.NPodAgent.API.TLivenessCheck': {
            'properties': {
                'container': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TUtilityContainer',
                    'additionalProperties': true,
                },
                'tcp_check': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TTcpCheck',
                    'additionalProperties': true,
                },
                'http_get': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.THttpGet',
                    'additionalProperties': true,
                },
                'failure_threshold': {
                    'type': 'integer',
                    'description':
                        'Минимальное число последовательных падений проверки после успешного выполнения, чтобы считать пробу упавшей Значение 0 воспринимается (по умолчанию) как 1',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Liveness Check',
            'description':
                'В случае ненулевого возврата или не успешном завершении http/tcp hook - workload убивается, и переходит в состояние DEACTIVATED_BY_LIVENESS',
        },
        'NInfra.NPodAgent.API.TMountedStaticResource': {
            'properties': {
                'resource_ref': {
                    'type': 'string',
                    'description': 'Id static_resource, который требуется подмонтировать',
                },
                'mount_point': {
                    'type': 'string',
                    'description':
                        'Точка монтирования Будет создана директория с этим путем, внутри директории будет лежать скаченный ресурс',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Mounted Static Resource',
        },
        'NInfra.NPodAgent.API.TMountedVolume': {
            'properties': {
                'volume_ref': {
                    'type': 'string',
                    'description': 'Id volume, который требуется подмонтировать',
                },
                'rbind_volume_ref': {
                    'type': 'string',
                    'description':
                        "Rbind volume ref Директория будет примонтирована из специальной директории rootfs pod'a: \u003cspecial_dir\u003e/\u003crbind_volume_ref\u003e",
                },
                'mount_point': {
                    'type': 'string',
                    'description': 'Точка монтирования',
                },
                'mode': {
                    'enum': ['EVolumeMountMode_READ_ONLY', 'EVolumeMountMode_READ_WRITE'],
                    'type': 'string',
                    'title': 'E Volume Mount Mode',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Mounted Volume',
            'description': 'Позволяет монитровать один вольюм в разные mountPoint',
        },
        'NInfra.NPodAgent.API.TMultiSecretFileContent': {
            'properties': {
                'format': {
                    'enum': [
                        'EMultiSecretFileContentFormat_JSON',
                        'EMultiSecretFileContentFormat_JAVA',
                        'EMultiSecretFileContentFormat_YAML',
                    ],
                    'type': 'string',
                    'title': 'E Multi Secret File Content Format',
                },
                'secret_alias': {
                    'type': 'string',
                    'description': 'Alias секрета из которого будут выписаны все значения',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Multi Secret File Content',
        },
        'NInfra.NPodAgent.API.TMutableWorkload': {
            'properties': {
                'workload_ref': {
                    'type': 'string',
                    'description': 'Ссылка на workload',
                },
                'target_state': {
                    'enum': ['EWorkloadTarget_ACTIVE', 'EWorkloadTarget_REMOVED'],
                    'type': 'string',
                    'title': 'E Workload Target State',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Mutable Workload',
            'description': 'Mutable поля Workload',
        },
        'NInfra.NPodAgent.API.TPodAgentResourceCacheSpec': {
            'properties': {
                'layers': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TCacheLayer',
                    },
                    'type': 'array',
                    'description': 'Кэш слои',
                },
                'static_resources': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TCacheResource',
                    },
                    'type': 'array',
                    'description': 'Кэш ресурсы',
                },
                'default_layer_source_file_storage_policy': {
                    'enum': [
                        'ELayerSourceFileStoragePolicy_NONE',
                        'ELayerSourceFileStoragePolicy_KEEP',
                        'ELayerSourceFileStoragePolicy_REMOVE',
                    ],
                    'type': 'string',
                    'title': 'E Layer Source File Storage Policy',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Agent Resource Cache Spec',
            'description':
                'Кэш ресурсы, которые надо скачать на под. Хеш ресурса считается как hash(Url, Checksum, Place), т.е. он не зависит от Id/Revision/Meta/CheckPeriodMs/.. :   если в спеке пода окажется layer или ресурс, у которого совпал хеш с каким-то ресурсом из кэша,   то этот ресурс не будет закачиваться заново, а просто подставится из кэша. Для всех TResource с одинаковым хешом выбирается минимальное из времен TVerification::CheckPeriodMs :   т.е. если в спеку пода придет TResource, который лежит в кэше, но его период верификации меньше   периода верификации кэш ресурса, этот ресурс начнет верифицироваться с меньшим периодом Валидация: сущности имеют уникальные в рамках пода идентификаторы (Пара Id, Revision)',
        },
        'NInfra.NPodAgent.API.TPodAgentSpec': {
            'properties': {
                'revision': {
                    'type': 'integer',
                    'description':
                        'Pod revision, server-side монотонно возрастаюшая последовательность Стоит использовать только для связки объектов в пользовательских интерфейсах "Актуальность" объекта надо проверять по равенству spec_timestamp спеки/статуса',
                },
                'id': {
                    'type': 'string',
                    'description': 'Идентификатор пода',
                },
                'resources': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TResourceGang',
                    'additionalProperties': true,
                    'description': 'Слои и ресурсы, которые необходимо скачать в рамках лимитов @see ResourceGang',
                },
                'volumes': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TVolume',
                    },
                    'type': 'array',
                    'description': 'Все вольюмы',
                },
                'workloads': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TWorkload',
                    },
                    'type': 'array',
                    'description': 'Все workload, изменение любого поля приводит к рестарту @see MutableWorkloads',
                },
                'boxes': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TBox',
                    },
                    'type': 'array',
                    'description': 'Все окружения, в которых могут быть запущены Workloads',
                },
                'mutable_workloads': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TMutableWorkload',
                    },
                    'type': 'array',
                    'description': 'Часть Workload, изменение которой не приведет к полной пересборке Workload',
                },
                'target_state': {
                    'enum': [
                        'EPodAgentTargetState_UNKNOWN',
                        'EPodAgentTargetState_ACTIVE',
                        'EPodAgentTargetState_SUSPENDED',
                        'EPodAgentTargetState_REMOVED',
                    ],
                    'type': 'string',
                    'title': '============================== SPEC ==========================',
                    'description': '============================== SPEC ==========================',
                },
                'transmit_system_logs_policy': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TTransmitSystemLogsPolicy',
                    'additionalProperties': true,
                    'description': 'Политика отсылки системных логов',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Agent Spec',
            'description':
                'Конфигурация Пода, передаваемая в Pod-agent. Сущности верхнего уровня имеют уникальные в рамках Пода идентификаторы (поле Id) и могут ссылаться друг на друга по этим идентификаторам (поля *Refs). Валидация: нет висячих ссылок Валидация: на каждый Workload ссылается ровно один MutableWorkload, нет ссылок из MutableWorkload на несуществующие Workload',
        },
        'NInfra.NPodAgent.API.TReadinessCheck': {
            'properties': {
                'container': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TUtilityContainer',
                    'additionalProperties': true,
                },
                'tcp_check': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TTcpCheck',
                    'additionalProperties': true,
                },
                'http_get': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.THttpGet',
                    'additionalProperties': true,
                },
                'failure_threshold': {
                    'type': 'integer',
                    'description':
                        'Минимальное число последовательных падений проверки после успешного выполнения, чтобы считать пробу упавшей Значение 0 воспринимается (по умолчанию) как 1',
                },
                'success_threshold': {
                    'type': 'integer',
                    'description':
                        'Минимальное число последовательных успешных проверок после падения, чтобы считать пробу успешной Значение 0 воспринимается (по умолчанию) как 1',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Readiness Check',
            'description':
                'В случае возврата 0 контейнером или успешном завершении http/tcp hook - workload переходит в состояние ACTIVE, в других случаях SEMI_FAILED Нет такого кода возврата status hook, при котором контейнер будет убит Это соответствет текущему поведению instaceCTL и qloudinit      https://wiki.yandex-team.ru/jandekspoisk/sepe/instancectl/#ortho-tags      https://docs.platform.yandex-team.ru/doc/component#status_hook Если пользователь хочет пробпросить кастомный стуктурированный status, то рекомендуемое место для этого stdout этого хука',
        },
        'NInfra.NPodAgent.API.TResource': {
            'properties': {
                'id': {
                    'type': 'string',
                    'description':
                        "Уникальное имя ресурса (в рамках pod'а). Должно состоять только из символов, разрешенных в имени porto контейнера. (a..z, A..Z, 0..9, _-@:.)",
                },
                'meta': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TResourceMeta',
                    'additionalProperties': true,
                    'description':
                        'Не нужно для Pod-agent Мета информация о ресурсе, необходимо для интеграции с CI/CD',
                },
                'verification': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TVerification',
                    'additionalProperties': true,
                    'description': '@see TVerification',
                },
                'url': {
                    'type': 'string',
                    'description':
                        'URL для скачивания, протоколы: http, https, rbtorrent Для записи строчки в файл URL должен быть равен "raw:\u003cстрока\u003e", в этом случае будет создан файл с названием raw_file и содержимым \u003cстрока\u003e Только для тестов: можно указать путь к файлу на хосте "local:\u003cfilepath\u003e"',
                },
                'files': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TFiles',
                    'additionalProperties': true,
                    'description':
                        'Указать набор файлов внутри ресурса Внутри каждого из файлов могут быть записаны raw данные или секреты',
                },
                'sky_get': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TSkyGetDownload',
                    'additionalProperties': true,
                    'description': 'Вызов sky get с особыми параметрами',
                },
                'default_storage': {
                    'type': 'boolean',
                },
                'file_storage_ref': {
                    'type': 'string',
                    'description': 'Указатель на файловый сторедж',
                },
                'virtual_disk_id_ref': {
                    'type': 'string',
                    'description':
                        'Virtual disk, где будет расположен ресурс Ресурс будт скачан на porto volume, созданный на этом диске Валидация: должен совпадать с virtual_disk_id_ref у volume, box, которые используют этот ресурс',
                },
                'access_mode': {
                    'enum': ['EResourceAccessMode_664', 'EResourceAccessMode_660', 'EResourceAccessMode_600'],
                    'type': 'string',
                    'title': 'E Resource Access Mode',
                    'description': 'Deprecated',
                },
                'group_id': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TGroupId',
                    'additionalProperties': true,
                    'description':
                        'group_id, выставляемая на файлы с ресурсом. Так как ресурсы качаются в контексте пода, а не пользовательского бокса, то в момент закачки подовый агент ничего не знает про пользовательские uid/guid, именно по этому group_id в данном случае задается в виде числового значения. По дефолту group_id на файлы со статическими ресурсами задается как loadbase',
                },
                'access_permissions': {
                    'enum': [
                        'EResourceAccessPermissions_UNMODIFIED',
                        'EResourceAccessPermissions_660',
                        'EResourceAccessPermissions_600',
                    ],
                    'type': 'string',
                    'title': 'E Resource Access Permissions',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Resource',
        },
        'NInfra.NPodAgent.API.TResourceGang': {
            'properties': {
                'layers': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TLayer',
                    },
                    'type': 'array',
                },
                'static_resources': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TResource',
                    },
                    'type': 'array',
                },
                'compute_resources': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TComputeResources',
                    'additionalProperties': true,
                    'description':
                        'Ограничения на meta контейнер, в рамках которого запускаются контейнеры download_* и verify_* Изменение гарантий/лимитов производится "на лету" - без остановки запущенных подконтейнеров Изменение гарантий в меньшую сторону может привести к прерыванию запущенных подконтейнеров',
                },
                'active_download_containers_limit': {
                    'type': 'integer',
                    'description':
                        'Максимальное количество одновременно работающих download контейнеров Если равно 0, то будет интерпретироваться как 3',
                },
                'default_layer_source_file_storage_policy': {
                    'enum': [
                        'ELayerSourceFileStoragePolicy_NONE',
                        'ELayerSourceFileStoragePolicy_KEEP',
                        'ELayerSourceFileStoragePolicy_REMOVE',
                    ],
                    'type': 'string',
                    'title': 'E Layer Source File Storage Policy',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Resource Gang',
            'description':
                'Позволяет выставить ограничение сверху на все закачки. Важным моментом является, что сумма лимитов ресурсов может быть больше, чем даже лимиты Pod. Поэтому pod-agent должен будет запускать закачки так: Снача запускаются закачки для активных workload и параллельно запускаются только те, которые можно разместить в рамках лимитов box',
        },
        'NInfra.NPodAgent.API.TResourceMeta': {
            'properties': {
                'sandbox_resource': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TSandboxResource',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Resource Meta',
        },
        'NInfra.NPodAgent.API.TRootfsVolume': {
            'properties': {
                'quota_bytes': {
                    'type': 'integer',
                    'description':
                        'Квота на размер Поле не обрабатывается - porto не умеет во вложенные квоты по диску',
                },
                'layer_refs': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description':
                        'Слои, из которых собирается volume Как и в porto, слои идут в порядке top-layer;...;bottom-layer Валидация: ids в списке должны быть уникальные',
                },
                'create_mode': {
                    'enum': ['EVolumeCreateMode_READ_WRITE', 'EVolumeCreateMode_READ_ONLY'],
                    'type': 'string',
                    'title': 'E Volume Create Mode',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Rootfs Volume',
        },
        'NInfra.NPodAgent.API.TSandboxResource': {
            'properties': {
                'task_type': {
                    'type': 'string',
                },
                'task_id': {
                    'type': 'string',
                },
                'resource_type': {
                    'type': 'string',
                },
                'resource_id': {
                    'type': 'string',
                },
                'attributes': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description':
                        'Attributes of sandbox resource, e.g.   "backup_task": "577303390",   "released": "testing",   "ttl": "inf",   "version": "1.200"',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Sandbox Resource',
        },
        'NInfra.NPodAgent.API.TSkyGetDownload': {
            'properties': {
                'resid': {
                    'type': 'string',
                    'description': 'Идентификатор ресурса Например rbtorrent:\u003cидентификатор ресурса\u003e',
                },
                'deduplicate': {
                    'enum': [
                        'ESkyGetDeduplicateMode_NO',
                        'ESkyGetDeduplicateMode_HARDLINK',
                        'ESkyGetDeduplicateMode_SYMLINK',
                    ],
                    'type': 'string',
                    'title': 'E Sky Get Deduplicate Mode',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Sky Get Download',
            'description':
                'Документация по параметрам https://doc.yandex-team.ru/Search/skynet-dg/concepts/sky-get.html#request-format',
        },
        'NInfra.NPodAgent.API.TStopPolicy': {
            'properties': {
                'container': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TUtilityContainer',
                    'additionalProperties': true,
                },
                'http_get': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.THttpGet',
                    'additionalProperties': true,
                },
                'unix_signal': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TUnixSignal',
                    'additionalProperties': true,
                },
                'max_tries': {
                    'type': 'integer',
                    'description':
                        'Количестно попыток выполнить gracefully stop перед тем, как убить процесс Валидация: должно быть \u003e 0',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Stop Policy',
            'description':
                'При переводе TMutableWorkload.TargetState в состояние REMOVED или обновления ревизии workload или любой его зависимости будет вызван stop hook, который должен выполнить gracefully завершение контейнера start Если после завершения stop hook контейнер start находится в состоянии dead или stopped, то он будет уничтожен, иначе stop hook будет перезапускаться до тех пор, пока контейнер start не перейдет в одно из этих состояний Если stop hook был запущен max_tries раз, но так и не перевел start в состоянии dead или stopped, то start будет немедленно убит Если stop hook выполняется при помощи контейнера и завершился с НУЛЕВЫМ кодом возврата, но start не в состоянии dead или stopped, то start будет немедленно убит Если stop hook выполняется при помощи http запроса и завершился успешно, но start не в состоянии dead или stopped, то start будет немедленно убит Если stop hook выполняется при помощи unix сигнала, то никаких дополнительных действий с start контейнером в случае успешной/неуспешной попытки послать сигнал не будет',
        },
        'NInfra.NPodAgent.API.TTcpCheck': {
            'properties': {
                'port': {
                    'type': 'integer',
                },
                'time_limit': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TTimeLimit',
                    'additionalProperties': true,
                    'description': '@see TTimeLimit',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Tcp Check',
            'description': 'Проверяет только, что connect по данному порту успешно завершился',
        },
        'NInfra.NPodAgent.API.TTimeLimit': {
            'properties': {
                'initial_delay_ms': {
                    'type': 'integer',
                    'description':
                        'Если равен 0, то будет интерпретироваться как 5000 (5 секунд) для всех типов workload readiness/liveness и workload unix signal stop Для остальных контейнеров остается без изменений',
                },
                'restart_period_scale_ms': {
                    'type': 'integer',
                },
                'restart_period_back_off': {
                    'type': 'integer',
                },
                'max_restart_period_ms': {
                    'type': 'integer',
                    'description': 'Если равен 0, то будет интерпретироваться как 18446744073709551615 (UINT64_MAX)',
                },
                'min_restart_period_ms': {
                    'type': 'integer',
                    'description': 'Если равен 0, то будет интерпретироваться как 30000 (30 секунд)',
                },
                'max_execution_time_ms': {
                    'type': 'integer',
                    'description': 'Если равен 0, то будет интерпретироваться как 1800000 (30 минут)',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Time Limit',
            'description':
                'Ограничения на время исполнения и интервал между запусками хука. Все времена в миллисекундах, однако времена, возвращаемые porto, имеют точность до секунды. Поэтому все значения будут округляться вверх до секунд. maxExecutionTimeMs - ограничение на время выполнения. Интервал между запусками рассчитывается по формуле min(maxRestartPeriodMs, minRestartPeriodMs + restartPeriodScaleMs * (restartPeriodBackoff ^ step)) step считается с 0 и равен max(0, ConsecutiveFailuresCounter - 1) для workload container/http stop и всех типов workload destroy и max(0, ConsecutiveSuccessesCounter - 1) для всех остальных хуков: все типы workload readiness, все типы workload liveness, workload init, workload unix signal stop',
        },
        'NInfra.NPodAgent.API.TTransmitSystemLogsPolicy': {
            'properties': {
                'transmit_system_logs': {
                    'enum': [
                        'ETransmitSystemLogsPolicy_NONE',
                        'ETransmitSystemLogsPolicy_DISABLED',
                        'ETransmitSystemLogsPolicy_ENABLED',
                    ],
                    'type': 'string',
                    'title': 'E Transmit System Logs',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Transmit System Logs Policy',
        },
        'NInfra.NPodAgent.API.TUlimitSoft': {
            'properties': {
                'name': {
                    'enum': [
                        'EContainerULimit_AS',
                        'EContainerULimit_CORE',
                        'EContainerULimit_DATA',
                        'EContainerULimit_MEMLOCK',
                        'EContainerULimit_STACK',
                        'EContainerULimit_FSIZE',
                        'EContainerULimit_NOFILE',
                        'EContainerULimit_CPU',
                        'EContainerULimit_LOCKS',
                        'EContainerULimit_MSGQUEUE',
                        'EContainerULimit_NICE',
                        'EContainerULimit_NPROC',
                        'EContainerULimit_RSS',
                        'EContainerULimit_RTPRIO',
                        'EContainerULimit_RTTIME',
                        'EContainerULimit_SIGPENDING',
                    ],
                    'type': 'string',
                    'title': 'E Container U Limit Type',
                },
                'value': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Ulimit Soft',
        },
        'NInfra.NPodAgent.API.TUnixSignal': {
            'properties': {
                'signal': {
                    'enum': [
                        'EUnixSignalType_DEFAULT',
                        'EUnixSignalType_SIGHUP',
                        'EUnixSignalType_SIGINT',
                        'EUnixSignalType_SIGALRM',
                        'EUnixSignalType_SIGKILL',
                        'EUnixSignalType_SIGTERM',
                        'EUnixSignalType_SIGUSR1',
                        'EUnixSignalType_SIGUSR2',
                        'EUnixSignalType_SIGURG',
                        'EUnixSignalType_SIGQUIT',
                    ],
                    'type': 'string',
                    'title': 'E Unix Signal Type',
                },
                'time_limit': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TTimeLimit',
                    'additionalProperties': true,
                    'description': '@see TTimeLimit',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Unix Signal',
            'description': 'Посылает сигнал процессу',
        },
        'NInfra.NPodAgent.API.TUtilityContainer': {
            'properties': {
                'compute_resources': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TComputeResources',
                    'additionalProperties': true,
                    'description':
                        'Атрибуты контейнера (по сути это сквозной проброс опций Porto) Тут важно разделять интерфейс предоствляемый пользователю и внутренний между YP\u003c-\u003eagent',
                },
                'command_line': {
                    'type': 'string',
                    'description':
                        'Будет вызван exec команды, она не выполняется внутри оболочки, поэтому команды содержащие "|", "\u003e" не будут работать Если ваш слой содержит bash, вы можете выполнить такие команды следующим образом: bash -c "echo hello world \u003e file"',
                },
                'time_limit': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TTimeLimit',
                    'additionalProperties': true,
                    'description': '@see TTimeLimit',
                },
                'core_command': {
                    'type': 'string',
                    'description': 'Параметры обработки корок',
                },
                'user': {
                    'type': 'string',
                    'description':
                        'Пользователь, владеющий процессами контейнера Если пользователь не указан, то будет выставлен root',
                },
                'group': {
                    'type': 'string',
                    'description':
                        'Группа, владеющая процессами контейнера Если группа не указана, то будет выставлен root',
                },
                'cwd': {
                    'type': 'string',
                    'description': 'Рабочая директория контейнера',
                },
                'stdout_file': {
                    'type': 'string',
                    'description':
                        'Путь относительно корня бокса до файла для stdout Если файл не указан, то он будет создан внутри porto, а не внутри бокса',
                },
                'stderr_file': {
                    'type': 'string',
                    'description':
                        'Путь относительно корня бокса до файла для stderr Если файл не указан, то он будет создан внутри porto, а не внутри бокса',
                },
                'stdout_and_stderr_limit': {
                    'type': 'integer',
                    'description':
                        'Ограничение на размер stdout и stderr Если выставлен 0, то будет использовано стандартное значение porto, например, для 4.18.20 ограничение будет 8388608',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Utility Container',
            'description':
                'Наследует env от TWorkload, если принадлежит ему Наследует env от TBox, если является init коммандой этого box',
        },
        'NInfra.NPodAgent.API.TVerification': {
            'properties': {
                'checksum': {
                    'type': 'string',
                    'description':
                        'Контрольная сумма, формат \u003cсхема\u003e:\u003cзначение\u003e Поддерживаемые схемы "MD5:", "EMPTY:", "SHA256:" - case sensitive',
                },
                'check_period_ms': {
                    'type': 'integer',
                    'description':
                        'Периодичность проверки контрольной суммы. Первая проверка выполняется сразу после завершения скачивания. Если проверка упадет, то все боксы (и ворклоды в них), в которые смонтирован ресурс, будут убиты c SIGKILL, ресурс будет перезакачен, после чего боксы будут пересобраны. Если равен 0, то будет интерпретироваться как 180000 (3 минуты)',
                },
                'disabled': {
                    'type': 'boolean',
                    'description': 'Если true, то ресурс не будет проверяться на checksum.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Verification',
            'description': 'Проверки целостности ресурса',
        },
        'NInfra.NPodAgent.API.TVolume': {
            'properties': {
                'id': {
                    'type': 'string',
                    'description':
                        "Уникальное имя volume (в рамках pod'а). Должно состоять только из символов, разрешенных в имени porto контейнера. (a..z, A..Z, 0..9, _-@:.)",
                },
                'storage': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TFileStorage',
                    'additionalProperties': true,
                    'description': 'TODO: not implemented',
                },
                'generic': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TGenericVolume',
                    'additionalProperties': true,
                },
                'virtual_disk_id_ref': {
                    'type': 'string',
                    'description':
                        'Virtual disk, где будет расположен volume Volume будет создан в place, находящемся на этом виртуальном диске Валидация: должен совпадать с virtual_disk_id_ref у слоев, из которых собирается volume',
                },
                'static_resources': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TVolumeMountedStaticResource',
                    },
                    'type': 'array',
                    'description': 'Валидация: все mount_point различны',
                },
                'persistence_type': {
                    'enum': ['EVolumePersistenceType_PERSISTENT', 'EVolumePersistenceType_NON_PERSISTENT'],
                    'type': 'string',
                    'title': 'E Volume Persistence Type',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Volume',
        },
        'NInfra.NPodAgent.API.TVolumeMountedStaticResource': {
            'properties': {
                'resource_ref': {
                    'type': 'string',
                    'description': 'Id static_resource, который требуется подмонтировать',
                },
                'volume_relative_mount_point': {
                    'type': 'string',
                    'description':
                        'Точка монтирования Будет создана директория с этим путем (путь относительно корня volume), внутри директории будет лежать скаченный ресурс',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Volume Mounted Static Resource',
        },
        'NInfra.NPodAgent.API.TWorkload': {
            'properties': {
                'id': {
                    'type': 'string',
                    'description':
                        "Уникальное имя workload (в рамках pod'а). Должно состоять только из символов, разрешенных в имени porto контейнера. (a..z, A..Z, 0..9, _-@:.)",
                },
                'box_ref': {
                    'type': 'string',
                    'description': 'Указатель на Box, в котором workload будет запущен',
                },
                'env': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TEnvVar',
                    },
                    'type': 'array',
                    'description': 'Переменные окружения - прокидываются во все контейнеры ворклода',
                },
                'ulimit_soft': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TUlimitSoft',
                    },
                    'type': 'array',
                    'description': 'Soft лимиты окружения - прокидываются во все контейнеры ворклода',
                },
                'init': {
                    'items': {
                        '$ref': '#/definitions/NInfra.NPodAgent.API.TUtilityContainer',
                    },
                    'type': 'array',
                    'description':
                        'Набор команд, запускаемых перед стартом основного процесса. Гарантируется, что каждая отработает at least once. Если команда падает - она перезапускается до победного',
                },
                'start': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TUtilityContainer',
                    'additionalProperties': true,
                    'description': 'Описание основного процесса',
                },
                'readiness_check': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TReadinessCheck',
                    'additionalProperties': true,
                    'description': '@see TReadinessCheck',
                },
                'liveness_check': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TLivenessCheck',
                    'additionalProperties': true,
                    'description': '@see TLivenessCheck',
                },
                'stop_policy': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TStopPolicy',
                    'additionalProperties': true,
                    'description': '@see TStopPolicy',
                },
                'destroy_policy': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TDestroyPolicy',
                    'additionalProperties': true,
                    'description': '@see TDestroyPolicy',
                },
                'transmit_logs': {
                    'type': 'boolean',
                    'description':
                        'Передавать логи stdout и stderr в YT Должно быть выставлено не более одного из: этот флаг и start.stdout_file/stderr_file/stdout_and_stderr_limit',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Workload',
        },
        'NYP.NClient.NApi.NClusterApiProto.ConfigurationId': {
            'properties': {
                'groupId': {
                    'type': 'string',
                    'description':
                        'Группа, в которую входит задача - берется из GroupTransition. ConfigurationId.family в кешере',
                },
                'extendedGroupId': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.ExtendedGroupId',
                    'additionalProperties': true,
                    'description': 'вариант id для meta-clusterapi',
                },
                'groupStateFingerprint': {
                    'type': 'string',
                    'description':
                        'Идентификатор целевого состояния группы. Произвольная строка. ConfigurationId.id в кешере',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Configuration Id',
            'description': 'Идентификатор конфигурации - описания целевого состояния группы задач.',
        },
        'NYP.NClient.NApi.NClusterApiProto.Container': {
            'properties': {
                'constraints': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description': 'Свойства porto-контейнеров хуков, задаваемые непосредственно.',
                },
                'withDynamicProperties': {
                    'type': 'boolean',
                    'description':
                        'Пытаться применять изменения в constraints без рестарта контейнера (аналогично portoctl set на запущенный контейнер) https://wiki.yandex-team.ru/iss3/specifications/configuration/container/#dinamicheskoeizmeneniesvojjstvkontejjnera',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Container',
            'description':
                'Описание контейнера, в котором запускается хук. https://wiki.yandex-team.ru/iss3/specifications/configuration/container/',
        },
        'NYP.NClient.NApi.NClusterApiProto.DynamicResource': {
            'properties': {
                'uuid': {
                    'type': 'string',
                },
                'queue': {
                    'type': 'string',
                },
                'verification': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Verification',
                    'additionalProperties': true,
                },
                'urls': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                },
                'sizeBytes': {
                    'type': 'integer',
                },
                'cached': {
                    'type': 'boolean',
                },
                'storage': {
                    'type': 'string',
                },
                'trafficClass': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.TrafficClass',
                    'additionalProperties': true,
                    'description': 'Ограничение скорости закачки',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Dynamic Resource',
            'description':
                'Динамический ресурс Может обновляться без перезапуска демона, при обновлении запускается iss_hook_notify https://wiki.yandex-team.ru/iss3/specifications/configuration/resource/#dinamicheskijjresurs Поля те же, что и у ресурса',
        },
        'NYP.NClient.NApi.NClusterApiProto.Entity': {
            'properties': {
                'instance': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Instance',
                    'additionalProperties': true,
                },
                'job': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Job',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Entity',
        },
        'NYP.NClient.NApi.NClusterApiProto.ExtendedGroupId': {
            'properties': {
                'id': {
                    'type': 'string',
                },
                'capiId': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Extended Group Id',
        },
        'NYP.NClient.NApi.NClusterApiProto.Feature': {
            'properties': {
                'name': {
                    'type': 'string',
                    'description': 'Имя опции, например, "bind_ro_resources"',
                },
                'properties': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description': 'Дополнительные настройки, связанные с включением опции',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Feature',
            'description': 'Опция поведения агента, например, "монтировать ли ресурсы в режиме read-only"',
        },
        'NYP.NClient.NApi.NClusterApiProto.HostConfiguration': {
            'properties': {
                'instances': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.HostConfigurationInstance',
                    },
                    'type': 'array',
                },
                'pod_volumes': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Volume',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Host Configuration',
            'description': 'Целевое состояние хоста и агента',
        },
        'NYP.NClient.NApi.NClusterApiProto.HostConfigurationInstance': {
            'properties': {
                'id': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.WorkloadId',
                    'additionalProperties': true,
                },
                'entity': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Entity',
                    'additionalProperties': true,
                },
                'properties': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description': 'Пользовательские свойства Пробрасываются хукам через переменные среды',
                },
                'targetState': {
                    'type': 'string',
                    'description': 'Целевое состояние - одно из "ACTIVE", "PREPARED", "REMOVED"',
                },
                'transitionTimestamp': {
                    'type': 'integer',
                    'description': 'Момент задания целевого состояния в формате UNIX timestamp',
                },
                'dynamicProperties': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description':
                        'Свойства, изменения которых не приводят к перезапуску. ISS-4434 Не должны пересекаться по ключам c properties',
                },
                'instanceRevision': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.InstanceRevision',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Host Configuration Instance',
            'description': 'Обертка для job/instance',
        },
        'NYP.NClient.NApi.NClusterApiProto.HostMount': {
            'properties': {
                'host_path': {
                    'type': 'string',
                    'description': 'Расположение директории на хосте',
                },
                'mount_point': {
                    'type': 'string',
                    'description': 'Точка монтирования директории в инстансе',
                },
                'mount_option': {
                    'type': 'string',
                    'description': 'Опция монтирования, допустимые значения: "bind", "rbind"',
                },
                'read_only': {
                    'type': 'boolean',
                    'description': 'Нужно ли монтировать в режиме read only',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Host Mount',
            'description': 'Хостовая директория, смонтированная в mount namespace инстанса',
        },
        'NYP.NClient.NApi.NClusterApiProto.Instance': {
            'properties': {
                'container': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Container',
                    'additionalProperties': true,
                    'description': 'Ограничения для всех хуков',
                },
                'volumes': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Volume',
                    },
                    'type': 'array',
                },
                'resources': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Resourcelike',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': '\u003cимя ресурса\u003e -\u003e \u003cописание ресурса\u003e',
                },
                'timeLimits': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.TimeLimit',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description':
                        '\u003cимя хука\u003e -\u003e \u003cвременные лимиты\u003e Имена хуков см https://wiki.yandex-team.ru/iss3/Specifications/configuration/instance/#naznacheniexukov',
                },
                'storage': {
                    'type': 'string',
                    'description':
                        'Точка монтирования, в которой создается рабочая директория инстанса. По умолчанию - "/".',
                },
                'project': {
                    'type': 'string',
                    'description': 'ACL-идентификатор владельца шаред-вольюмов Нужно для data locality ISS-3660',
                },
                'volumeRefs': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.VolumeRef',
                    },
                    'type': 'array',
                    'description': 'ссылки на внешние шаред-вольюмы Нужно для data locality ISS-3660',
                },
                'layers': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Resource',
                    },
                    'type': 'array',
                    'description': 'Слои, из которых собирается корневой раздел',
                },
                'host_mounts': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.HostMount',
                    },
                    'type': 'array',
                    'description': 'Хостовые директории или файлы, смонтированные в mount namespace инстанса',
                },
                'features': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Feature',
                    },
                    'type': 'array',
                    'description':
                        'Отдельно включаемые и выключаемые изменения в поведении агента, например: "монтировать ли ресурсы в режиме read-only" Использование этих опций полезно в двух случаях: 1. Если для изменения в поведении не нужны дополнительные настройки (например, bind_ro_resources) 2. Если схематизировать настройки нового поведения не выгодно по каким-то причинам, например:    - мы ещё не готовы фиксировать схему, т.к. не уверены в ней, и она будет многократно меняться;    - чтобы не ждать выкладки релиза YP, когда нам достаточно потестить поведение на паре хостов,      куда мы можем быстро доставить новую версию ISS-агента.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title':
                '------------------------------- Описания запускаемых сущностей (демоны и задачи) ------------------------------------',
            'description':
                '------------------------------- Описания запускаемых сущностей (демоны и задачи) ------------------------------------  Демон, он же инстанс - после завершения сущность перезапускается каждый раз, пока не будет удалена с кластера Подробнее здесь - https://wiki.yandex-team.ru/iss3/Specifications/configuration/instance/',
        },
        'NYP.NClient.NApi.NClusterApiProto.Job': {
            'properties': {
                'container': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Container',
                    'additionalProperties': true,
                },
                'volumes': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Volume',
                    },
                    'type': 'array',
                },
                'resources': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Resourcelike',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
                'timeLimits': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.TimeLimit',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
                'storage': {
                    'type': 'string',
                },
                'project': {
                    'type': 'string',
                },
                'volumeRefs': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.VolumeRef',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Job',
            'description':
                'Задача, она же джоб - выполняется один раз и не перезапускается. Поля те же, что и у демона https://wiki.yandex-team.ru/iss3/specifications/configuration/job/ Поля копируют содержимое Instance на случай будущих изменений, если эти классы разойдутся',
        },
        'NYP.NClient.NApi.NClusterApiProto.Resource': {
            'properties': {
                'uuid': {
                    'type': 'string',
                    'description': 'Уникальный идентификатор (произвольная строка)',
                },
                'queue': {
                    'type': 'string',
                    'description':
                        'Имя очереди закачки (пустое - качается без очереди) https://wiki.yandex-team.ru/iss3/specifications/agent/downloadqueues/',
                },
                'verification': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Verification',
                    'additionalProperties': true,
                },
                'urls': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description':
                        'Ссылки на ресурс, например, "rbtorrent:2f83ff0f5b98b315ce356e129ce1e00d7b67ec7d", "http://cmsearch.yandex.ru/res"',
                },
                'sizeBytes': {
                    'type': 'integer',
                    'description': 'Размер ресурса в байтах',
                },
                'cached': {
                    'type': 'boolean',
                    'description':
                        'Является ли ресурс закешированным https://wiki.yandex-team.ru/iss3/Specifications/ShardTracker/#upravleniesvobodnymmestom',
                },
                'storage': {
                    'type': 'string',
                    'description': 'Точка монтирования, в которой будет скачан ресурс (см. Instance.storage)',
                },
                'trafficClass': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.TrafficClass',
                    'additionalProperties': true,
                    'description': 'Ограничение скорости закачки',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Resource',
            'description': 'Обычный ресурс - набор данных',
        },
        'NYP.NClient.NApi.NClusterApiProto.Resourcelike': {
            'properties': {
                'resource': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Resource',
                    'additionalProperties': true,
                },
                'dynamicResource': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.DynamicResource',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Resourcelike',
            'description': 'Базовый класс ресурса',
        },
        'NYP.NClient.NApi.NClusterApiProto.Slot': {
            'properties': {
                'service': {
                    'type': 'string',
                    'description': 'Идентификатор сервиса на хосте, например (но не обязательно), порт',
                },
                'host': {
                    'type': 'string',
                    'description': 'FQDN хоста',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Slot',
            'description':
                'Место под сервис на хосте Если две сущности используют один слот, то только одна из них может быть активной в каждый момент времени',
        },
        'NYP.NClient.NApi.NClusterApiProto.TimeLimit': {
            'properties': {
                'restartPeriodScaleMs': {
                    'type': 'integer',
                },
                'restartPeriodBackOff': {
                    'type': 'integer',
                },
                'maxRestartPeriodMs': {
                    'type': 'integer',
                },
                'minRestartPeriodMs': {
                    'type': 'integer',
                },
                'maxExecutionTimeMs': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Time Limit',
            'description':
                'Ограничения на время исполнения и интервал между запусками хука. Все времена в миллисекундах. maxExecutionTimeMs - ограничение на время выполнения. Интервал между запусками рассчитывается по формуле min(maxRestartPeriodMs, minRestartPeriodMs + restartPeriodScaleMs * (restartPeriodBackoff ^ step)) step считается с 0',
        },
        'NYP.NClient.NApi.NClusterApiProto.TrafficClass': {
            'properties': {
                'downloadSpeedLimit': {
                    'type': 'integer',
                },
                'trafficTag': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Traffic Class',
        },
        'NYP.NClient.NApi.NClusterApiProto.Verification': {
            'properties': {
                'checksum': {
                    'type': 'string',
                    'description':
                        'Контрольная сумма, формат \u003cсхема\u003e:\u003cзначение\u003e Поддерживаемые схемы "MD5:", "EMPTY:" - case sensitive',
                },
                'checkPeriod': {
                    'type': 'string',
                    'description':
                        'Периодичность проверки контрольной суммы. При значении 0d0h0m проверка будет выполнена только 1 раз.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Verification',
            'description': 'Проверки целостности ресурса',
        },
        'NYP.NClient.NApi.NClusterApiProto.Volume': {
            'properties': {
                'quotaBytes': {
                    'type': 'integer',
                    'description': 'Квота на размер корневого раздела',
                },
                'quotaCwdBytes': {
                    'type': 'integer',
                    'description': 'Квота на размер рабочей директории',
                },
                'mountPoint': {
                    'type': 'string',
                    'description': 'точка монтирования',
                },
                'properties': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description':
                        'Сейчас определено только свойство bind https://wiki.yandex-team.ru/iss3/specifications/configuration/instance/volumes/#polzovatelskijjbind',
                },
                'layers': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Resource',
                    },
                    'type': 'array',
                    'description': 'Слои, из которых собирается корневой раздел',
                },
                'uuid': {
                    'type': 'string',
                    'description': 'Указывается при создании shared-volume',
                },
                'storage': {
                    'type': 'string',
                    'description':
                        'Точка монтирования, в которой будет создан volume, будут храниться его данные и распаковываться слои. По умолчанию создается под "/", данные хранятся в стандартных директориях porto.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title':
                '------------------------------------------------ Данные -------------------------------------------------------------',
            'description':
                '------------------------------------------------ Данные -------------------------------------------------------------  Раздел porto Подробное описание здесь https://wiki.yandex-team.ru/iss3/specifications/configuration/instance/volumes/',
        },
        'NYP.NClient.NApi.NClusterApiProto.VolumeRef': {
            'properties': {
                'uuid': {
                    'type': 'string',
                    'description': 'идентификатор шаред-вольюма',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Volume Ref',
            'description': 'Ссылка на шаред-вольюм',
        },
        'NYP.NClient.NApi.NClusterApiProto.WorkloadId': {
            'properties': {
                'slot': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.Slot',
                    'additionalProperties': true,
                },
                'configuration': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.ConfigurationId',
                    'additionalProperties': true,
                    'description':
                        'Название конфигурации в формате \u003cсемейство\u003e#\u003cимя конфигурации в семействе\u003e',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Workload Id',
            'description': 'Уникальный идентификатор задачи',
        },
        'NYP.NClient.NApi.NProto.TAccessControlEntry': {
            'required': ['action'],
            'properties': {
                'action': {
                    'enum': ['ACA_ALLOW', 'ACA_DENY'],
                    'type': 'string',
                    'title': '//////////////////////////////////////////////////////////////////////////////',
                    'description': '//////////////////////////////////////////////////////////////////////////////',
                },
                'permissions': {
                    'items': {
                        'enum': [
                            'ACP_NONE',
                            'ACP_READ',
                            'ACP_READ_SECRETS',
                            'ACA_WRITE',
                            'ACA_CREATE',
                            'ACA_SSH_ACCESS',
                            'ACA_ROOT_SSH_ACCESS',
                            'ACA_USE',
                            'ACA_GET_QYP_VM_STATUS',
                        ],
                    },
                    'type': 'array',
                    'title': 'E Access Control Permission',
                },
                'subjects': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description': 'List of subjects (users and groups) this entry applies to.',
                },
                'attributes': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description':
                        'List of attribute paths this entry applies to. If this list is not specified or empty, this entry is applied to the root attribute path.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Access Control Entry',
        },
        'NYP.NClient.NApi.NProto.TAddDeployChild': {
            'properties': {
                'fqid': {
                    'type': 'string',
                    'description': 'Fully-qualified id of the child.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description': '//////////////////////////////////////////////////////////////////////////////',
        },
        'NYP.NClient.NApi.NProto.TAddSecretDelegation': {
            'properties': {
                'secret_id': {
                    'type': 'string',
                    'description': 'Secret id assigned by the Vault.',
                },
                'delegation_token': {
                    'type': 'string',
                    'description':
                        'Delegation token provided by the Vault. If the field is empty, master will fetch a token using current user credentials.',
                },
                'fail_if_already_present': {
                    'type': 'boolean',
                    'description': 'Report failure (and abort transaction) if the delegation is already established.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Add Secret Delegation',
        },
        'NYP.NClient.NApi.NProto.TAggregatedCondition': {
            'properties': {
                'pod_count': {
                    'type': 'integer',
                    'description': 'Number of pods for which condition is true',
                },
                'condition': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCondition',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Aggregated Condition',
        },
        'NYP.NClient.NApi.NProto.TAlertToleration': {
            'required': ['type', 'effect'],
            'properties': {
                'type': {
                    'type': 'string',
                    'description': 'Corresponds to type of the node alert one wants to ignore.',
                },
                'effect': {
                    'type': 'string',
                    'description':
                        'Corresponds to effect of the node alert. In order for scheduler to ignore a node alert, both "key" and "effect" of respective toleration should coincide with those specified in the alert. If "effect" is not specified, scheduler will ignore all node alerts with a given type.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description': '//////////////////////////////////////////////////////////////////////////////',
        },
        'NYP.NClient.NApi.NProto.TAntiaffinityConstraint': {
            'required': ['key', 'max_pods'],
            'properties': {
                'key': {
                    'type': 'string',
                    'description':
                        "Topology zone key. Node zones are specified via /node/labels/topology/key=value labels. and are filled on node's import. Supported zone keys are: node, rack, dc.",
                },
                'max_pods': {
                    'type': 'integer',
                    'description': 'Maximum number of pods that can be placed in the same zone.',
                },
                'pod_group_id_path': {
                    'type': 'string',
                    'description':
                        'If given, the constraint is independently applied to each group of pods with equal group id at which this path points. Path must be of the form /labels/\u003ckey\u003e, where \u003ckey\u003e represents a single path token. Otherwise scheduling will fail for the pod set with appropriate error. A pod is not required to have specified group id. If group id is missing, the pod will not be affected by the constraint. If pod group id is specified, it must be of the string type. Otherwise scheduling will fail for the pod with appropriate error. Example: pod_group_id_path = "/labels/antiaffinity_group_id" and /pod/labels/antiaffinity_group_id = "42".',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description': '//////////////////////////////////////////////////////////////////////////////',
        },
        'NYP.NClient.NApi.NProto.TBoxJugglerConfig': {
            'properties': {
                'archived_checks': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDownloadableResource',
                    },
                    'type': 'array',
                    'description': "Tarballs with user's checks (may be compressed).",
                },
                'juggler_agent_binary': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDownloadableResource',
                    'additionalProperties': true,
                    'description':
                        'Juggler agent binary resource. Empty juggler_agent_binary will be replace by default',
                },
                'port': {
                    'type': 'integer',
                    'description': 'juggler-client will listen on this port',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Box Juggler Config',
        },
        'NYP.NClient.NApi.NProto.TCPUMetricSpec': {
            'properties': {
                'lower_bound': {
                    'type': 'number',
                    'description':
                        'Target interval of cpu usage. Autoscaler will skip scaling if: current_metric ∈ [lower_bound, upper_bound] Scale: cores - same as signal havg(portoinst-cpu_usage_slot_hgram) Validation: lower_bound \u003c= upper_bound',
                },
                'upper_bound': {
                    'type': 'number',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description':
                '//////////////////////////////////////////////////////////////////////////////  Autoscaler will use pod average cpu usage (currently - for last 5 min) as a metric yasm signal: havg(portoinst-cpu_usage_slot_hgram)',
        },
        'NYP.NClient.NApi.NProto.TCPUUtilizationMetricSpec': {
            'properties': {
                'lower_bound_percent': {
                    'type': 'integer',
                    'description':
                        'Target interval of cpu usage in percent. Autoscaler will skip scaling if: current_metric ∈ [lower_bound_percent, upper_bound_percent] Scale: cores in percent - same as signal havg(portoinst-cpu_limit_usage_perc_hgram) Validation: lower_bound_percent \u003c= upper_bound_percent and lower_bound_percent, upper_bound_percent ∈ [0, 100]',
                },
                'upper_bound_percent': {
                    'type': 'integer',
                },
                'period': {
                    'pattern': '^([0-9]+\\.?[0-9]*|\\.[0-9]+)s$',
                    'type': 'string',
                    'description': 'Validation: period ∈ {5s, 5m, 1h, 3h, 6h, 12h, 1d} Default: 5 min (may change)',
                    'format': 'regex',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'TCPU Utilization Metric Spec',
            'description':
                'Autoscaler will use pod average cpu usage (currently - for last 5 min) as a metric yasm signal: havg(portoinst-cpu_limit_usage_perc_hgram)',
        },
        'NYP.NClient.NApi.NProto.TChecksum': {
            'properties': {
                'type': {
                    'enum': ['EMPTY', 'MD5', 'SHA256'],
                    'type': 'string',
                    'title': 'E Checksum Type',
                },
                'value': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Checksum',
        },
        'NYP.NClient.NApi.NProto.TClusterDeployStatus': {
            'properties': {
                'details': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployStatusDetails',
                    'additionalProperties': true,
                },
                'pod_set_id': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Cluster Deploy Status',
        },
        'NYP.NClient.NApi.NProto.TCondition': {
            'properties': {
                'status': {
                    'enum': ['CS_UNKNOWN', 'CS_TRUE', 'CS_FALSE'],
                    'type': 'string',
                    'title': '//////////////////////////////////////////////////////////////////////////////',
                    'description': '//////////////////////////////////////////////////////////////////////////////',
                },
                'reason': {
                    'type': 'string',
                    'description': 'One word (e.g. PROCESS_CRASH) for computers and short summary',
                },
                'message': {
                    'type': 'string',
                    'description': 'Some human readable message',
                },
                'last_transition_time': {
                    'type': 'string',
                    'format': 'date-time',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Condition',
        },
        'NYP.NClient.NApi.NProto.TControllerAttempt': {
            'properties': {
                'succeeded': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCondition',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Controller Attempt',
        },
        'NYP.NClient.NApi.NProto.TControllerStatus': {
            'properties': {
                'last_attempt': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TControllerAttempt',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Controller Status',
        },
        'NYP.NClient.NApi.NProto.TCoredumpAggregator': {
            'properties': {
                'enabled': {
                    'type': 'boolean',
                },
                'url': {
                    'type': 'string',
                    'description': 'URL to aggregator, use https://coredumps.n.yandex-team.ru/submit_core by default',
                },
                'service_name': {
                    'type': 'string',
                    'description': 'Specify service name tag for trace, use "deploy.stageId.workloadId" by default',
                },
                'ctype': {
                    'type': 'string',
                    'description': 'Specify ctype tag for trace, empty by default',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Coredump Aggregator',
            'description': 'Coredump config',
        },
        'NYP.NClient.NApi.NProto.TCoredumpPolicy': {
            'properties': {
                'coredump_processor': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCoredumpProcessor',
                    'additionalProperties': true,
                    'description': 'Instancectl coredump settings',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Coredump Policy',
        },
        'NYP.NClient.NApi.NProto.TCoredumpProcessor': {
            'properties': {
                'count_limit': {
                    'type': 'integer',
                    'description': 'Limit on coredumps stored count',
                },
                'total_size_limit_megabytes': {
                    'type': 'integer',
                    'description': 'Limit on coredumps stored size in megabytes',
                },
                'probability': {
                    'type': 'integer',
                    'description': 'Save core with specified probability',
                },
                'aggregator': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCoredumpAggregator',
                    'additionalProperties': true,
                },
                'cleanup_ttl_seconds': {
                    'type': 'integer',
                    'description':
                        'We can remove old coredumps when writing new one if total size limit exceeded or count limit exceeded. But we want to avoid too frequent coredumps creation and disk pressure if user\'s process is indefinitely crashing immediately after start. So we will remove old coredump and free up space for the new one only if old coredump was created earlier than "current_time - cleanup_ttl_seconds"',
                },
                'output': {
                    'type': 'string',
                    'description': 'Specify custom path for storing coredumps',
                },
                'volume_id': {
                    'type': 'string',
                    'description':
                        'Specify volume id for storing coredumps, volume should be mounted to box where workload with enabled coredump',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Coredump Processor',
        },
        'NYP.NClient.NApi.NProto.TCustomMetricSpec': {
            'properties': {
                'golovan_signal': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCustomMetricSpec.TGolovanSignal',
                    'additionalProperties': true,
                },
                'solomon_signal': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCustomMetricSpec.TSolomonSignal',
                    'additionalProperties': true,
                },
                'lower_bound': {
                    'type': 'number',
                    'description':
                        'Target interval of metric. Autoscaler will skip scaling if: current_metric ∈ [lower_bound, upper_bound] Validation: lower_bound \u003c= upper_bound',
                },
                'upper_bound': {
                    'type': 'number',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Custom Metric Spec',
            'description': 'yasm signal: golovan_signal.signal',
        },
        'NYP.NClient.NApi.NProto.TCustomMetricSpec.TGolovanSignal': {
            'properties': {
                'signal': {
                    'type': 'string',
                },
                'tags': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                },
                'period': {
                    'enum': [
                        'GP_DEFAULT',
                        'GP_FIVE_SEC',
                        'GP_FIVE_MIN',
                        'GP_ONE_HOUR',
                        'GP_THREE_HOURS',
                        'GP_SIX_HOURS',
                        'GP_TWELVE_HOURS',
                        'GP_ONE_DAY',
                    ],
                    'type': 'string',
                    'title': 'E Golovan Period',
                },
                'set_local_geo_tag': {
                    'type': 'boolean',
                    'description': "if true then Golovan request will contain 'geo=\u003cYP_CLUSTER\u003e' tag",
                },
                'host': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Golovan Signal',
        },
        'NYP.NClient.NApi.NProto.TCustomMetricSpec.TSolomonSignal': {
            'properties': {
                'project': {
                    'type': 'string',
                },
                'cluster': {
                    'type': 'string',
                },
                'service': {
                    'type': 'string',
                },
                'host': {
                    'type': 'string',
                },
                'sensor': {
                    'type': 'string',
                },
                'path': {
                    'type': 'string',
                },
                'period': {
                    'pattern': '^([0-9]+\\.?[0-9]*|\\.[0-9]+)s$',
                    'type': 'string',
                    'description': 'Default: 5 min (may change)',
                    'format': 'regex',
                },
                'aggregation': {
                    'enum': ['AT_UNKNOWN', 'AT_AVG', 'AT_MAX', 'AT_MIN', 'AT_SUM', 'AT_LAST'],
                    'type': 'string',
                    'title': 'E Aggregation Type',
                },
                'advanced_attributes': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Solomon Signal',
        },
        'NYP.NClient.NApi.NProto.TDeployProgress': {
            'properties': {
                'pods_ready': {
                    'type': 'integer',
                    'description': 'Number of pods synced to up-to-date spec.',
                },
                'pods_in_progress': {
                    'type': 'integer',
                    'description': 'Number of pods currently updating.',
                },
                'pods_total': {
                    'type': 'integer',
                    'description': 'Total number of pods.',
                },
                'pods_failed': {
                    'type': 'integer',
                    'description': 'Number of failed pods.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description': '//////////////////////////////////////////////////////////////////////////////',
        },
        'NYP.NClient.NApi.NProto.TDeployReadyCriterion': {
            'properties': {
                'ready_threshold': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployReadyCriterion.TReadyThreshold',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Ready Criterion',
        },
        'NYP.NClient.NApi.NProto.TDeployReadyCriterion.TReadyThreshold': {
            'properties': {
                'type': {
                    'type': 'string',
                    'title':
                        'MAX_NOT_READY_PODS\n Replica set is ready \u003c=\u003e\n num_pods - ready_pods \u003c= max_not_ready_pods.value.',
                    'description':
                        'MAX_UNAVAILABLE Replica set is ready \u003c=\u003e num_pods - ready_pods \u003c= max_unavailable (disruption budget).  AUTO Replica set is ready \u003c=\u003e  at least auto computed number in RSC of pods are ready.  MIN_READY_PODS_PERCENT Replica set is ready \u003c=\u003e  ready_pods \u003e= ceil(min_ready_pods_percent.value / 100 * num_pods)  MAX_NOT_READY_PODS Replica set is ready \u003c=\u003e num_pods - ready_pods \u003c= max_not_ready_pods.value.',
                },
                'min_ready_pods_percent': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployReadyCriterion.TReadyThreshold.TMinReadyPodsPercent',
                    'additionalProperties': true,
                },
                'max_not_ready_pods': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployReadyCriterion.TReadyThreshold.TMaxNotReadyPods',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Ready Threshold',
            'description':
                'type - enum which determines threshold. type values and condition which corresponds to this value:',
        },
        'NYP.NClient.NApi.NProto.TDeployReadyCriterion.TReadyThreshold.TMaxNotReadyPods': {
            'properties': {
                'value': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Max Not Ready Pods',
        },
        'NYP.NClient.NApi.NProto.TDeployReadyCriterion.TReadyThreshold.TMinReadyPodsPercent': {
            'properties': {
                'value': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Min Ready Pods Percent',
        },
        'NYP.NClient.NApi.NProto.TDeploySpeed': {
            'properties': {
                'update_portion': {
                    'type': 'integer',
                    'description': 'Number of pods to update at a time.',
                },
                'min_delay': {
                    'type': 'integer',
                    'description': 'Min delay in seconds between updates.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Speed',
        },
        'NYP.NClient.NApi.NProto.TDeployStatusDetails': {
            'properties': {
                'total_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployProgress',
                    'additionalProperties': true,
                },
                'current_revision_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployProgress',
                    'additionalProperties': true,
                },
                'controller_status': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TControllerStatus',
                    'additionalProperties': true,
                },
                'revisions': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployProgress',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': 'Legacy attribute, use mapped_revisions instead.',
                },
                'mapped_revisions': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployProgress',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Status Details',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitApproval': {
            'properties': {
                'user': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitApproval.TUserApproval',
                    'additionalProperties': true,
                },
                'payload': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitApproval.TApprovalPayload',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Unit Approval',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitApproval.TApprovalPayload': {
            'properties': {
                'revision': {
                    'type': 'integer',
                },
                'cluster': {
                    'type': 'string',
                },
                'deploy_unit': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Approval Payload',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitApproval.TUserApproval': {
            'properties': {
                'login': {
                    'type': 'string',
                },
                'status': {
                    'enum': ['NONE', 'DISAPPROVED', 'APPROVED'],
                    'type': 'string',
                    'title': 'E User Approval Status',
                },
                'approval_time': {
                    'type': 'string',
                    'format': 'date-time',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T User Approval',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitOverrides': {
            'properties': {
                'per_cluster_overrides': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitOverrides.TPerClusterOverrides',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
                'revision_to_override': {
                    'type': 'integer',
                },
                'deploy_settings_override': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitOverrides.TDeploySettingsOverride',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Unit Overrides',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitOverrides.TDeploySettingsOverride': {
            'properties': {
                'author': {
                    'type': 'string',
                },
                'approval_time': {
                    'type': 'string',
                    'format': 'date-time',
                },
                'deploy_settings': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec.TDeploySettings',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Settings Override',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitOverrides.TPerClusterOverrides': {
            'properties': {
                'max_unavailable': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitOverrides.TPerClusterOverrides.TNumericOverride',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Per Cluster Overrides',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitOverrides.TPerClusterOverrides.TNumericOverride': {
            'properties': {
                'value': {
                    'type': 'integer',
                },
                'author': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Numeric Override',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitSpec': {
            'properties': {
                'network_defaults': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TNetworkDefaults',
                    'additionalProperties': true,
                },
                'replica_set': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec.TReplicaSetDeploy',
                    'additionalProperties': true,
                },
                'multi_cluster_replica_set': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec.TMultiClusterReplicaSetDeploy',
                    'additionalProperties': true,
                },
                'tvm_config': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TTvmConfig',
                    'additionalProperties': true,
                },
                'images_for_boxes': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDockerImageDescription',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description':
                        '\u003cbox id\u003e -\u003e \u003cdocker image description\u003e. If box id is present in this map, layers from corresponding docker image will be added below layers specified in pod agent spec. NOTE: box id must be present in pod agent spec.',
                },
                'endpoint_sets': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec.TEndpointSetTemplate',
                    },
                    'type': 'array',
                },
                'box_juggler_configs': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TBoxJugglerConfig',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description':
                        '\u003cbox id\u003e -\u003e \u003cjuggler config for box\u003e. If box id is present in this map, a juggler workload will be added to it. NOTE: box id must be present in pod agent spec.',
                },
                'logbroker_config': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TLogbrokerConfig',
                    'additionalProperties': true,
                },
                'logrotate_configs': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TLogrotateConfig',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
                'revision': {
                    'type': 'integer',
                },
                'sox_service': {
                    'type': 'boolean',
                },
                'coredump_config': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCoredumpPolicy',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
                'tvm_sandbox_info': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TSandboxResourceInfo',
                    'additionalProperties': true,
                },
                'pod_agent_sandbox_info': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TSandboxResourceInfo',
                    'additionalProperties': true,
                },
                'pod_agent_layer_sandbox_info': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TSandboxResourceInfo',
                    'additionalProperties': true,
                },
                'logbroker_tools_sandbox_info': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TSandboxResourceInfo',
                    'additionalProperties': true,
                },
                'dynamic_resource_updater_sandbox_info': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TSandboxResourceInfo',
                    'additionalProperties': true,
                },
                'deploy_settings': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec.TDeploySettings',
                    'additionalProperties': true,
                },
                'patchers_revision': {
                    'type': 'integer',
                    'description': 'Spec patchers revision',
                },
                'enable_dynamic_resource_updater': {
                    'type': 'boolean',
                    'description': 'Bring dynamic resource updater sidecar to boxes',
                },
                'infra_components': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TInfraComponents',
                    'additionalProperties': true,
                },
                'collect_portometrics_from_sidecars': {
                    'type': 'boolean',
                    'description': 'Enable portoworkload metrics gathering for infra sidecars',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Unit Spec',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitSpec.TClusterSettings': {
            'properties': {
                'yp_cluster': {
                    'type': 'string',
                },
                'need_approval': {
                    'type': 'boolean',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Cluster Settings',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitSpec.TDeploySettings': {
            'properties': {
                'cluster_sequence': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec.TClusterSettings',
                    },
                    'type': 'array',
                },
                'deploy_strategy': {
                    'enum': ['SEQUENTIAL', 'PARALLEL'],
                    'type': 'string',
                    'title': 'E Deploy Strategy',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Settings',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitSpec.TEndpointSetTemplate': {
            'properties': {
                'port': {
                    'type': 'integer',
                },
                'protocol': {
                    'type': 'string',
                },
                'liveness_limit_ratio': {
                    'type': 'number',
                },
                'id': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Endpoint Set Template',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitSpec.TMultiClusterReplicaSetDeploy': {
            'properties': {
                'replica_set': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Multi Cluster Replica Set Deploy',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitSpec.TReplicaSetDeploy': {
            'properties': {
                'replica_set_template': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetSpec',
                    'additionalProperties': true,
                },
                'per_cluster_settings': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec.TReplicaSetDeploy.TPerClusterSettings',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Replica Set Deploy',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitSpec.TReplicaSetDeploy.TPerClusterSettings': {
            'properties': {
                'pod_count': {
                    'type': 'integer',
                },
                'autoscale': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetScaleSpec',
                    'additionalProperties': true,
                    'description': 'Will spawn horizontal pod autoscaler above replica set',
                },
                'deployment_strategy': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetSpec.TDeploymentStrategy',
                    'additionalProperties': true,
                    'description': 'If present, override replica_set_template.deployment_strategy value.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Per Cluster Settings',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitStatus': {
            'properties': {
                'current_target': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec',
                    'additionalProperties': true,
                    'description': 'Spec that is currently being deployed. May be older than contents of TStageSpec.',
                },
                'in_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCondition',
                    'additionalProperties': true,
                    'description': 'Deploy of current_target has started, but has not completed yet.',
                },
                'ready': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCondition',
                    'additionalProperties': true,
                    'description':
                        'Deploy of current_target has been completed. May switch back to false if something breaks later.',
                },
                'failed': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCondition',
                    'additionalProperties': true,
                    'description':
                        'Deploy of current_target has started, has not completed yet and had error during start.',
                },
                'progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployProgress',
                    'additionalProperties': true,
                    'description': 'Summary of deploy progress.',
                },
                'target_revision': {
                    'type': 'integer',
                    'description': "Revision of stage from which 'current_target' was derived.",
                },
                'target_spec_timestamp': {
                    'type': 'integer',
                    'description': "YP timestamp of stage spec from which 'current_target' was derived.",
                },
                'yasm_itype': {
                    'type': 'string',
                    'description':
                        'User-specified itype if unit spec has one, controller-generated default otherwise. Current default is "deploy".',
                },
                'patchers_revision': {
                    'type': 'integer',
                    'description': 'Currently applied spec patchers revision',
                },
                'replica_set': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitStatus.TReplicaSetDeploy',
                    'additionalProperties': true,
                },
                'multi_cluster_replica_set': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitStatus.TMultiClusterReplicaSetDeploy',
                    'additionalProperties': true,
                },
                'latest_deployed_revision': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Unit Status',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitStatus.TMultiClusterReplicaSetDeploy': {
            'properties': {
                'replica_set_id': {
                    'type': 'string',
                    'description': 'Created multi cluster replica set id.',
                },
                'cluster_statuses': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitStatus.TMultiClusterReplicaSetDeploy.TPerClusterStatus',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': '\u003ccluster id\u003e -\u003e \u003ccluster status\u003e.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Multi Cluster Replica Set Deploy',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitStatus.TMultiClusterReplicaSetDeploy.TPerClusterStatus': {
            'properties': {
                'endpoint_set_id': {
                    'type': 'string',
                    'description': 'Deprecated.',
                },
                'endpoint_set_ids': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description': 'Created endpoint sets in this cluster.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Per Cluster Status',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitStatus.TReplicaSetDeploy': {
            'properties': {
                'cluster_statuses': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitStatus.TReplicaSetDeploy.TPerClusterStatus',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': '\u003ccluster id\u003e -\u003e \u003ccluster status\u003e.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Replica Set Deploy',
        },
        'NYP.NClient.NApi.NProto.TDeployUnitStatus.TReplicaSetDeploy.TPerClusterStatus': {
            'properties': {
                'replica_set_id': {
                    'type': 'string',
                    'description': 'Created replica set id in this cluster.',
                },
                'endpoint_set_id': {
                    'type': 'string',
                    'description': 'Deprecated.',
                },
                'horizontal_pod_autoscaler_id': {
                    'type': 'string',
                    'description': 'Created horizontal pod autoscaler id in this cluster.',
                },
                'endpoint_set_ids': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description': 'Created endpoint sets in this cluster.',
                },
                'status': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus',
                    'additionalProperties': true,
                    'description': 'Last known replica set status.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Per Cluster Status',
        },
        'NYP.NClient.NApi.NProto.TDockerImageDescription': {
            'properties': {
                'registry_host': {
                    'type': 'string',
                    'description': 'Docker registry host name, defaults to "registry.yandex.net".',
                },
                'name': {
                    'type': 'string',
                    'description': 'Image name, for example, "search/ubuntu".',
                },
                'tag': {
                    'type': 'string',
                    'description': 'Image tag, for example, "1.189".',
                },
                'digest': {
                    'type': 'string',
                    'description':
                        'Image digest, for example, "sha256:cbbf2f9a99b47fc460d422812b6a5adff7dfee951d8fa2e4a98caa0382cfbdbf".',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Docker Image Description',
            'description': 'Identity is value-based - two descriptions are same if all their fields are equal.',
        },
        'NYP.NClient.NApi.NProto.TDownloadableResource': {
            'properties': {
                'url': {
                    'type': 'string',
                },
                'checksum': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TChecksum',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description':
                '//////////////////////////////////////////////////////////////////////////////  Represents an arbitrary downloadable resource.',
        },
        'NYP.NClient.NApi.NProto.TDynamicResourceSpec': {
            'properties': {
                'revision': {
                    'type': 'integer',
                    'description': 'Resource revision, server-side incremented sequence, monotonic.',
                },
                'deploy_groups': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDynamicResourceSpec.DeployGroup',
                    },
                    'type': 'array',
                },
                'update_window': {
                    'type': 'integer',
                    'description': 'Size of the update window in pods.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Dynamic Resource Spec',
        },
        'NYP.NClient.NApi.NProto.TDynamicResourceSpec.DeployGroup': {
            'properties': {
                'mark': {
                    'type': 'string',
                    'description': 'Short label to describe the deploy group.',
                },
                'required_labels': {
                    '$ref': '#/definitions/NYT.NYTree.NProto.TAttributeDictionary',
                    'additionalProperties': true,
                    'description':
                        'Conjunction of labels required for this deploy group to be applied. Note, that if one pod matches more than one deploy groups, neither one will be applied, since such configuration appears to be ambigous and invalid. Empty map matches every single pod in pod_set.',
                },
                'urls': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description':
                        'Urls where to download the resource from supported protocols: http, https, rbtorrent, raw (for raw resources use "raw:data"). Urls are tried in order until successful download.',
                },
                'storage_options': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodDynamicResourceSpec.TStorageOptions',
                    'additionalProperties': true,
                    'description': 'Options how to handle resource inside the box.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Deploy Group',
            'description':
                'Specification group, describing resource deploy rules for a part of pod_set filtered by a set of labels.',
        },
        'NYP.NClient.NApi.NProto.TDynamicResourceStatus.TRevisionStatus': {
            'properties': {
                'revision': {
                    'type': 'integer',
                    'description': 'Revision id',
                },
                'mark': {
                    'type': 'string',
                    'description': 'Short label describing deploy group.',
                },
                'ready': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TAggregatedCondition',
                    'additionalProperties': true,
                    'description': 'Amount of pods where this revision is active.',
                },
                'in_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TAggregatedCondition',
                    'additionalProperties': true,
                    'description': 'Amount of pods where this revision is currently updating.',
                },
                'error': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TAggregatedCondition',
                    'additionalProperties': true,
                    'description': 'Amount of pods where resource update failed on installing this revision.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Revision Status',
        },
        'NYP.NClient.NApi.NProto.THostInfraInfo': {
            'properties': {
                'monitoring': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMonitoringInfo',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Host Infra Info',
        },
        'NYP.NClient.NApi.NProto.TInfraComponents': {
            'properties': {
                'update_policy': {
                    'enum': ['UNKNOWN', 'BETA', 'TESTING', 'PRESTABLE', 'STABLE'],
                    'type': 'string',
                    'title': 'E Update Policy',
                },
                'allow_automatic_updates': {
                    'type': 'boolean',
                    'description':
                        'update components automatically on stagectl side if explicit_update_timestamp stale',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Infra Components',
        },
        'NYP.NClient.NApi.NProto.TLogbrokerConfig': {
            'properties': {
                'push_agent_layer': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDownloadableResource',
                    'additionalProperties': true,
                    'description': 'Custom push agent. For development purposes only.',
                },
                'sidecar_bringup_mode': {
                    'enum': ['UNKNOWN', 'DEFAULT', 'MANDATORY'],
                    'type': 'string',
                    'title': 'E Sidecar Bringup Mode',
                },
                'sidecar_volume': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TSidecarVolume',
                    'additionalProperties': true,
                    'description': 'Disk volume settings for sidecar',
                },
                'logs_virtual_disk_id_ref': {
                    'type': 'string',
                    'description': 'Disk volume id where portolog files should be stored',
                },
                'destroy_policy': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TLogbrokerConfig.TLogbrokerDestroyPolicy',
                    'additionalProperties': true,
                },
                'communal_topic_request': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TLogbrokerConfig.TLogbrokerCommunalTopicRequest',
                    'additionalProperties': true,
                },
                'custom_topic_request': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TLogbrokerConfig.TLogbrokerCustomTopicRequest',
                    'additionalProperties': true,
                },
                'pod_additional_resources_request': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TResourceRequests',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Logbroker Config',
        },
        'NYP.NClient.NApi.NProto.TLogbrokerConfig.TLogbrokerCommunalTopicRequest': {
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Logbroker Communal Topic Request',
        },
        'NYP.NClient.NApi.NProto.TLogbrokerConfig.TLogbrokerCustomTopicRequest': {
            'properties': {
                'tvm_client_id': {
                    'type': 'integer',
                },
                'topic_name': {
                    'type': 'string',
                },
                'secret_selector': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.SecretSelector',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Logbroker Custom Topic Request',
        },
        'NYP.NClient.NApi.NProto.TLogbrokerConfig.TLogbrokerDestroyPolicy': {
            'properties': {
                'max_tries': {
                    'type': 'integer',
                    'description': 'missing or equal to 0 would be interpreted as 3 (default value)',
                },
                'restart_period_ms': {
                    'type': 'integer',
                    'description':
                        'minimal and default value is 10000 (10 sec). Value less than minimal - validation error',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Logbroker Destroy Policy',
        },
        'NYP.NClient.NApi.NProto.TLogrotateConfig': {
            'properties': {
                'raw_config': {
                    'type': 'string',
                },
                'run_period_millisecond': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Logrotate Config',
            'description': 'Config for rotates, compresses, and mails system logs (linux logrotate tool)',
        },
        'NYP.NClient.NApi.NProto.TMonitoringInfo': {
            'properties': {
                'unistats': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMonitoringUnistatEndpoint',
                    },
                    'type': 'array',
                },
                'yasm_subagents': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMonitoringSubagentEndpoint',
                    },
                    'type': 'array',
                },
                'juggler_subagents': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMonitoringSubagentEndpoint',
                    },
                    'type': 'array',
                },
                'labels': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description':
                        'Pod-wide yasm tags for signals. User-defined tags for deploy unit are stored here and then Deploy system tags are added by parts of Deploy stack until they arrive on node agent as part of pod spec. See https://wiki.yandex-team.ru/deploy/docs/stage/nastrojjka-postavki-metrik-v-yasm/#system-tags for list of Deploy tags.',
                },
                'pod_agent': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodAgentMonitoringSpec',
                    'additionalProperties': true,
                },
                'workloads': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMonitoringWorkloadEndpoint',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Monitoring Info',
        },
        'NYP.NClient.NApi.NProto.TMonitoringSubagentEndpoint': {
            'properties': {
                'port': {
                    'type': 'integer',
                },
                'path': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Monitoring Subagent Endpoint',
            'description': 'Subagent inside pod. https://wiki.yandex-team.ru/golovan/yasmagent/subagent/',
        },
        'NYP.NClient.NApi.NProto.TMonitoringUnistatEndpoint': {
            'properties': {
                'port': {
                    'type': 'integer',
                },
                'path': {
                    'type': 'string',
                    'description': 'Relative HTTP path to unistat handle.',
                },
                'prefix': {
                    'type': 'string',
                    'description': 'Prefix for signal names, default is unistat.',
                },
                'labels': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description':
                        'Tags for this endpoint. If a value in TMonitoringInfo.labels with same key exists, it will be overridden.',
                },
                'workload_id': {
                    'type': 'string',
                    'description': 'Workload in pod which provides this endpoint.',
                },
                'allow_porto_metrics': {
                    'type': 'boolean',
                    'description': 'Allow to collect porto metrics for workload',
                },
                'output_format': {
                    'enum': ['OF_UNKNOWN', 'OF_YASM_JSON', 'OF_YASM_PROTO', 'OF_SOLOMON'],
                    'type': 'string',
                    'title': 'E Output Format',
                },
                'inherit_missed_labels': {
                    'type': 'boolean',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description':
                '//////////////////////////////////////////////////////////////////////////////  User workload with unistat endpoint.',
        },
        'NYP.NClient.NApi.NProto.TMonitoringWorkloadEndpoint': {
            'properties': {
                'labels': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description':
                        'Workload-wide yasm tags for signals. User-defined tags for deploy unit are stored here and then Deploy system tags are added by parts of Deploy stack until they arrive on node agent as part of pod spec. See https://wiki.yandex-team.ru/deploy/docs/stage/nastrojjka-postavki-metrik-v-yasm/#system-tags for list of Deploy tags.',
                },
                'workload_id': {
                    'type': 'string',
                },
                'inherit_missed_labels': {
                    'type': 'boolean',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Monitoring Workload Endpoint',
        },
        'NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec': {
            'properties': {
                'revision': {
                    'type': 'integer',
                },
                'account_id': {
                    'type': 'string',
                },
                'pod_template_spec': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodTemplateSpec',
                    'additionalProperties': true,
                },
                'deployment_strategy': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec.TDeploymentStrategy',
                    'additionalProperties': true,
                },
                'clusters': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec.TClusterReplicaSetSpecPreferences',
                    },
                    'type': 'array',
                },
                'node_segment_id': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Multi Cluster Replica Set Spec',
        },
        'NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec.TClusterReplicaSetSpecPreferences': {
            'properties': {
                'cluster': {
                    'type': 'string',
                },
                'spec': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec.TReplicaSetSpecPreferences',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Cluster Replica Set Spec Preferences',
        },
        'NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec.TConstraints': {
            'properties': {
                'antiaffinity_constraints': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TAntiaffinityConstraint',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Constraints',
        },
        'NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec.TDeploymentStrategy': {
            'properties': {
                'max_unavailable': {
                    'type': 'integer',
                },
                'min_created_seconds': {
                    'type': 'integer',
                    'description': 'Minimum number of seconds after pod creation to be considered available.',
                },
                'max_tolerable_downtime_seconds': {
                    'type': 'integer',
                    'description':
                        'Max allowed hardware maintenance duration in seconds during which pods may be unavailable',
                },
                'max_tolerable_downtime_pods': {
                    'type': 'integer',
                    'description': 'max_unavailable analogue, but only for eviction/maintenance-related unavailability',
                },
                'deploy_speed': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeploySpeed',
                    'additionalProperties': true,
                    'description': 'Describes how many pods to update at a time and min delay between updates.',
                },
                'ready_criterion': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployReadyCriterion',
                    'additionalProperties': true,
                    'description': 'Conditions which determine if replica set is ready.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deployment Strategy',
        },
        'NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec.TReplicaSetSpecPreferences': {
            'properties': {
                'replica_count': {
                    'type': 'integer',
                },
                'constraints': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TMultiClusterReplicaSetSpec.TConstraints',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Replica Set Spec Preferences',
        },
        'NYP.NClient.NApi.NProto.TNetworkDefaults': {
            'properties': {
                'network_id': {
                    'type': 'string',
                },
                'override_ip6_address_requests': {
                    'type': 'boolean',
                    'description': 'Override non empty pod_template ip6_address_requests with default network_id',
                },
                'override_ip6_subnet_requests': {
                    'type': 'boolean',
                    'description': 'Override non empty pod_template ip6_subnet_requests with default network_id',
                },
                'virtual_service_ids': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                },
                'ip4_address_pool_id': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Deploy unit',
            'description': 'Deploy unit  Network settings for requests from infrastructure.',
        },
        'NYP.NClient.NApi.NProto.TPodAgentMonitoringSpec': {
            'properties': {
                'labels': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description':
                        'Pod-wide yasm tags for signals. User-defined tags for deploy unit are stored here and then Deploy system tags are added by parts of Deploy stack until they arrive on node agent as part of pod spec. See https://wiki.yandex-team.ru/deploy/docs/stage/nastrojjka-postavki-metrik-v-yasm/#system-tags for list of Deploy tags.',
                },
                'add_pod_agent_user_signals': {
                    'type': 'boolean',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Agent Monitoring Spec',
        },
        'NYP.NClient.NApi.NProto.TPodDynamicResourceSpec': {
            'properties': {
                'id': {
                    'type': 'string',
                    'description': 'Resource identifier.',
                },
                'revision': {
                    'type': 'integer',
                    'description': 'Desired revision of the resource.',
                },
                'mark': {
                    'type': 'string',
                    'description': 'Short label describing resource deploy group.',
                },
                'storage_options': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodDynamicResourceSpec.TStorageOptions',
                    'additionalProperties': true,
                },
                'urls': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description':
                        'URLs where to download the resource from supported protocols: http, https, rbtorrent, raw (for raw resources use "raw:data"). URLs are tried in order until successful download.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Dynamic Resource Spec',
        },
        'NYP.NClient.NApi.NProto.TPodDynamicResourceSpec.TStorageOptions': {
            'properties': {
                'box_ref': {
                    'type': 'string',
                    'description': 'Name of the box to download resource into.',
                },
                'destination': {
                    'type': 'string',
                    'description': 'Filesystem path where the application should see the resource.',
                },
                'storage_dir': {
                    'type': 'string',
                    'description': 'Filesystem path where resource versions should be downloaded.',
                },
                'http_action': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodDynamicResourceSpec.TStorageOptions.THttpAction',
                    'additionalProperties': true,
                },
                'exec_action': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodDynamicResourceSpec.TStorageOptions.TExecAction',
                    'additionalProperties': true,
                },
                'verification': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodDynamicResourceSpec.TStorageOptions.TVerification',
                    'additionalProperties': true,
                    'description': 'Rule how to check the resource.',
                },
                'cached_revisions_count': {
                    'type': 'integer',
                    'description':
                        "How many copies including actual one should be kept. It's not recommended to use less than 2 (default). If you set 1, your resource will be fully removed before downloading new revision.",
                },
                'allow_deduplication': {
                    'type': 'boolean',
                    'description':
                        'Allow resource to be deduplicated via hardlinks if present. Supported only for rbtorrent URLs. Use only if you know what you are doing! Hardlinked data can be corrupted by other users of the resource on the same host.',
                },
                'max_download_speed': {
                    'type': 'integer',
                    'description': 'Download speed limit in MBits per second. Supported only for rbtorrent URLs.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Storage Options',
        },
        'NYP.NClient.NApi.NProto.TPodDynamicResourceSpec.TStorageOptions.TExecAction': {
            'properties': {
                'command_line': {
                    'type': 'string',
                    'description': 'Shell command to execute.',
                },
                'expected_answer': {
                    'type': 'string',
                    'description': 'Stdout to accept, if empty, stdout is ignored.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Exec Action',
            'description': 'Shell command to exec to notify.',
        },
        'NYP.NClient.NApi.NProto.TPodDynamicResourceSpec.TStorageOptions.THttpAction': {
            'properties': {
                'url': {
                    'type': 'string',
                    'description': 'Url to call.',
                },
                'expected_answer': {
                    'type': 'string',
                    'description': 'Expected HTTP response body.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Http Action',
            'description':
                'HTTP GET handle to notify. HTTP response codes from range 200-299 are considered to be success.',
        },
        'NYP.NClient.NApi.NProto.TPodDynamicResourceSpec.TStorageOptions.TVerification': {
            'properties': {
                'checksum': {
                    'type': 'string',
                    'description':
                        'Checksum in the form: \u003cscheme\u003e:\u003cvalue\u003e Supported schemes are "MD5:", "EMPTY:", "SHA256:", all case sensitive.',
                },
                'check_period_ms': {
                    'type': 'integer',
                    'description': 'Period of checksum check. First check is done right after download.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Verification',
        },
        'NYP.NClient.NApi.NProto.TPodSpec': {
            'properties': {
                'iss_payload': {
                    'type': 'string',
                    'description':
                        'Raw ISS payload to be delivered to agent. COMPAT(babenko): will be deprecated after switching to pod agent.',
                    'format': 'binary',
                    'binaryEncoding': 'base64',
                },
                'iss': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NClusterApiProto.HostConfiguration',
                    'additionalProperties': true,
                    'description':
                        'Structured ISS spec. COMPAT(babenko): will be deprecated after switching to pod agent.',
                },
                'pod_agent_payload': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TPodAgentPayload',
                    'additionalProperties': true,
                    'description':
                        'Pod agent deployment and its workload specs. COMPAT(babenko): Either this or iss_payload/iss should be present.',
                },
                'node_id': {
                    'type': 'string',
                    'description':
                        "Node id this pod must be assigned to. XXX(babenko): WILL BE REMOVED SOON. DON'T USE.",
                },
                'scheduling': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TScheduling',
                    'additionalProperties': true,
                },
                'resource_requests': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TResourceRequests',
                    'additionalProperties': true,
                    'description':
                        'CPU, memory and other resources to allocate and configure for this pod upon assignment.',
                },
                'ip6_address_requests': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TIP6AddressRequest',
                    },
                    'type': 'array',
                    'description': 'IP6 addresses to allocate for this pod upon assignment.',
                },
                'ip6_subnet_requests': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TIP6SubnetRequest',
                    },
                    'type': 'array',
                    'description': 'IP6 subnets to allocate for this pod upon assignment.',
                },
                'disk_volume_requests': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TDiskVolumeRequest',
                    },
                    'type': 'array',
                    'description': 'Transient disk volumes to allocate for this pod upon assignment.',
                },
                'disk_volume_claims': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TDiskVolumeClaim',
                    },
                    'type': 'array',
                    'description':
                        'Persistent disk volumes (indirectly represented by claims) to mount into this pod upon assignment.',
                },
                'gpu_requests': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TGpuRequest',
                    },
                    'type': 'array',
                    'description': 'GPUs to allocate for this pod upon assignment.',
                },
                'enable_scheduling': {
                    'type': 'boolean',
                    'description': 'If false then YP will not be scheduling this pod.',
                },
                'node_filter': {
                    'type': 'string',
                    'description':
                        'If given, controls which nodes are eligible for this pod. Filter is a query language predicate; it can only refer to node labels, not other attributes.',
                },
                'host_devices': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.THostDevice',
                    },
                    'type': 'array',
                    'description':
                        'Host devices to configure. https://wiki.yandex-team.ru/porto/propertiesanddata/#resursy',
                },
                'sysctl_properties': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TSysctlProperty',
                    },
                    'type': 'array',
                    'description': 'Sysctl properties to configure.',
                },
                'virtual_service_options': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TVirtualServiceOptions',
                    'additionalProperties': true,
                },
                'host_name_kind': {
                    'enum': ['PHNK_TRANSIENT', 'PHNK_PERSISTENT'],
                    'type': 'string',
                    'title': 'E Pod Host Name Kind',
                },
                'secrets': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TSecret',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': 'Defines secrets to be delivered to the pod.',
                },
                'secret_refs': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TSecretRef',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': 'References secrets to be delivered to the pod.',
                },
                'disable_secret_validation': {
                    'type': 'boolean',
                    'description':
                        'If the following field is set, pod will be created without checking it secret references.',
                },
                'account_id': {
                    'type': 'string',
                    'description': "If given, overrides the podset's account.",
                },
                'dynamic_attributes': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TDynamicAttributes',
                    'additionalProperties': true,
                    'description': "Provides means to deliver certain parts of pod's metadata to the node.",
                },
                'dynamic_resources': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodDynamicResourceSpec',
                    },
                    'type': 'array',
                    'description': 'Dynamic resources for the pod.',
                },
                'resource_cache': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TPodAgentResourceCache',
                    'additionalProperties': true,
                    'description': 'Resource cache for the pod',
                },
                'out_of_memory_policy': {
                    'enum': ['OOMP_DEFAULT', 'OOMP_REBUILD_POD', 'OOMP_KILL_PROCESS'],
                    'type': 'string',
                    'title': 'E Pod Out Of Memory Policy',
                },
                'host_infra': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.THostInfraInfo',
                    'additionalProperties': true,
                    'description': 'Host infrastructure settings. Available on host via node agent REST interface.',
                },
                'capabilities': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description':
                        'Host capability names as they will be forwarded to node agent. http://man7.org/linux/man-pages/man7/capabilities.7.html',
                },
                'network_settings': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TNetworkSettings',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Spec',
            'description': 'Next field 30',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TDiskVolumeClaim': {
            'required': ['name', 'claim_id'],
            'properties': {
                'name': {
                    'type': 'string',
                    'description':
                        'Altogether, TDiskVolumeRequest.id and TDiskVolumeClaim.name are pod-wise unique and enable addressing volumes (both transient and persistent) within a pod.',
                },
                'labels': {
                    '$ref': '#/definitions/NYT.NYTree.NProto.TAttributeDictionary',
                    'additionalProperties': true,
                    'description': 'These labels get propagated to /pod/status/disk_volume_mounts/*/labels',
                },
                'claim_id': {
                    'type': 'string',
                    'description': 'Persistent volume claim whose associated volume must be mounted into the pod.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Disk Volume Claim',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TDiskVolumeRequest': {
            'required': ['id', 'storage_class'],
            'properties': {
                'id': {
                    'type': 'string',
                    'description': 'Pod-wise unique id. TODO(babenko): rename to "name"',
                },
                'labels': {
                    '$ref': '#/definitions/NYT.NYTree.NProto.TAttributeDictionary',
                    'additionalProperties': true,
                    'description': 'These labels get propagated to /pod/status/disk_volume_allocations/*/labels',
                },
                'storage_class': {
                    'type': 'string',
                    'description': 'E.g. ssd, hdd.',
                },
                'storage_provisioner': {
                    'type': 'string',
                    'description':
                        'Volume will be allocated on the disk with specified provisioner. Supported values: "lvm", "shared". Empty value is implicitly considered as "shared". Not specified by default.',
                },
                'quota_policy': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TDiskVolumeRequest.TQuotaPolicy',
                    'additionalProperties': true,
                },
                'exclusive_policy': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TDiskVolumeRequest.TExclusivePolicy',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Disk Volume Request',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TDiskVolumeRequest.TExclusivePolicy': {
            'required': ['min_capacity'],
            'properties': {
                'min_capacity': {
                    'type': 'integer',
                    'description':
                        'Minimum capacity the disk must have. The client, however, will be charged for the whole disk capacity.',
                },
                'min_bandwidth': {
                    'type': 'integer',
                    'description':
                        'Minimum bandwidth in bytes per second the disk must provide. The client, however, will be charged for the whole disk bandwidth.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Exclusive Policy',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TDiskVolumeRequest.TQuotaPolicy': {
            'required': ['capacity'],
            'properties': {
                'capacity': {
                    'type': 'integer',
                    'description': 'Guaranteed volume capacity.',
                },
                'bandwidth_guarantee': {
                    'type': 'integer',
                    'description': 'Guaranteed volume bandwidth in bytes per second.',
                },
                'bandwidth_limit': {
                    'type': 'integer',
                    'description': 'Volume bandwidth limit in bytes per second.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Quota Policy',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TDynamicAttributes': {
            'properties': {
                'annotations': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description': 'List of pod annotation keys to be delivered to the pod.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Dynamic Attributes',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TGpuRequest': {
            'required': ['id', 'model'],
            'properties': {
                'id': {
                    'type': 'string',
                    'description': 'Pod-wise unique id.',
                },
                'model': {
                    'type': 'string',
                    'description': 'GPU model.',
                },
                'min_memory': {
                    'type': 'integer',
                    'description': 'In bytes.',
                },
                'max_memory': {
                    'type': 'integer',
                    'description': 'In bytes.',
                },
                'mode': {
                    'enum': ['GM_NONE', 'GM_NVIDIA', 'GM_VFIO'],
                    'type': 'string',
                    'title': 'E Gpu Mode',
                    'description':
                        'It is assumed that GPU device is just a generic PCIe device, it may operate in various mutably exclusive modes. See https://doc.yandex-team.ru/nvgpu_manager/design.html',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Gpu Request',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.THostDevice': {
            'required': ['path', 'mode'],
            'properties': {
                'path': {
                    'type': 'string',
                    'description': 'E.g. /dev/kvm',
                },
                'mode': {
                    'type': 'string',
                    'description': 'E.g. "r", "rw"',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Host Device',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TIP6AddressRequest': {
            'required': ['network_id', 'vlan_id'],
            'properties': {
                'network_id': {
                    'type': 'string',
                    'description': 'Id of network_project. This attribute supports update without rescheduling.',
                },
                'vlan_id': {
                    'type': 'string',
                    'description': 'Will be matched against /node/spec/ip6_subnets/*/vlan_id.',
                },
                'labels': {
                    '$ref': '#/definitions/NYT.NYTree.NProto.TAttributeDictionary',
                    'additionalProperties': true,
                    'description': 'These labels get propagated to /pod/status/ip6_address_allocations/*/labels',
                },
                'enable_dns': {
                    'type': 'boolean',
                    'description': 'If true, this address is published to DNS.',
                },
                'dns_prefix': {
                    'type': 'string',
                    'description': 'If non-empty, full DNS name is prepended with this string (plus dot).',
                },
                'enable_internet': {
                    'type': 'boolean',
                    'description':
                        'If true, internet tunnels is configured (InternetAddress is allocated and assigned to pod). See st/YP-1213.',
                },
                'virtual_service_ids': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description': 'If given, virtual service tunnels are configured.',
                },
                'ip4_address_pool_id': {
                    'type': 'string',
                    'description':
                        'If given, InternetAddress is allocated in given pool. Otherwise InternetAddress is allocated in default pool if enable_internet is set.',
                },
                'priority': {
                    'type': 'integer',
                    'description':
                        'Determines sorting of addresses in porto properties. Higher comes later. Among equivalent addresses, the last one is selected as the default for outgoing packets. Suggested assignment is in increments of 100.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'TIP 6 Address Request',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TIP6SubnetRequest': {
            'required': ['vlan_id'],
            'properties': {
                'network_id': {
                    'type': 'string',
                    'description':
                        'Id of network_project. If omitted, no network configuration is actually being applied at nodes; however the IP6 address nonce is still being reserved.',
                },
                'vlan_id': {
                    'type': 'string',
                    'description': 'Will be matched against /node/spec/ip6_subnets/*/vlan_id.',
                },
                'labels': {
                    '$ref': '#/definitions/NYT.NYTree.NProto.TAttributeDictionary',
                    'additionalProperties': true,
                    'description': 'These labels get propagated to /node/status/ip6_subnet_allocations/*/labels',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'TIP 6 Subnet Request',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TNetworkSettings': {
            'properties': {
                'ip_limit': {
                    'type': 'boolean',
                    'description':
                        'Enables porto ip_limit. https://bb.yandex-team.ru/projects/PORTO/repos/porto/browse/porto.md',
                },
                'extra_routes': {
                    'type': 'boolean',
                    'description': 'Enables additional router settings from /etc/default/portod.conf.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Network Settings',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TPodAgentContainerResources': {
            'properties': {
                'vcpu_guarantee': {
                    'type': 'integer',
                    'description':
                        'All CPU limits are need to set in milli CPU (vcpu). 1000 vcpu equals 1 real core. Desired CPU power.',
                },
                'vcpu_limit': {
                    'type': 'integer',
                    'description': 'CPU usage limit.',
                },
                'memory_guarantee': {
                    'type': 'integer',
                    'description': 'Guarantee for memory_usage.',
                },
                'memory_limit': {
                    'type': 'integer',
                    'description': 'Limit for memory_usage.',
                },
                'anonymous_memory_limit': {
                    'type': 'integer',
                    'description': 'Limit for anon_usage (offstream kernel feature).',
                },
                'recharge_on_pgfault': {
                    'type': 'boolean',
                    'description':
                        'If true immigrate cache on minor page fault, default: false (offstream kernel feature).',
                },
                'thread_limit': {
                    'type': 'integer',
                    'description': 'Limit for thread_count.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Agent Container Resources',
            'description':
                'It must be binary compatibility with TComputeResources from https://a.yandex-team.ru/arc/trunk/arcadia/yp/yp_proto/yp/client/api/proto/pod_agent.proto see https://bb.yandex-team.ru/projects/PORTO/repos/porto/browse/porto.md',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TPodAgentDeploymentMeta': {
            'properties': {
                'url': {
                    'type': 'string',
                    'description':
                        'URL to download pod agent binary from. This might be unified with TLayer now, but they may diverge later, so leave it here.',
                },
                'checksum': {
                    'type': 'string',
                    'description': '\u003cscheme\u003e:\u003chex value\u003e. Supported schemes are "MD5" and "EMPTY".',
                },
                'configuration': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description': 'Arguments to be passed to pod agent via command line.',
                },
                'layers': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TPodAgentDeploymentMeta.TLayer',
                    },
                    'type': 'array',
                    'description':
                        'List of layers to construct pod chroot fs from, from top to bottom (same order as used by porto).',
                },
                'sidecar_volume': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TSidecarVolume',
                    'additionalProperties': true,
                    'description': 'Disk volume settings for sidecar',
                },
                'binary_revision': {
                    'type': 'integer',
                    'description': 'pod agent binary sandbox revision',
                },
                'compute_resources': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TPodAgentContainerResources',
                    'additionalProperties': true,
                    'description': 'It describe porto limits for pod agent container.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Agent Deployment Meta',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TPodAgentDeploymentMeta.TLayer': {
            'properties': {
                'url': {
                    'type': 'string',
                    'description': 'URL to download layer from.',
                },
                'checksum': {
                    'type': 'string',
                    'description': '\u003cscheme\u003e:\u003chex value\u003e. Supported schemes are "MD5" and "EMPTY".',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Layer',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TPodAgentPayload': {
            'properties': {
                'spec': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TPodAgentSpec',
                    'additionalProperties': true,
                },
                'meta': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TPodAgentDeploymentMeta',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Agent Payload',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TPodAgentResourceCache': {
            'properties': {
                'spec': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TPodAgentResourceCacheSpec',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Agent Resource Cache',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TResourceRequests': {
            'properties': {
                'vcpu_guarantee': {
                    'type': 'integer',
                    'description': 'In virtual millicores.',
                },
                'vcpu_limit': {
                    'type': 'integer',
                },
                'vcpu_limit_scalable': {
                    'type': 'boolean',
                    'description': 'Requests automatic increase of vcpu_limit when the node is underutilized.',
                },
                'memory_guarantee': {
                    'type': 'integer',
                    'description': 'In bytes.',
                },
                'memory_limit': {
                    'type': 'integer',
                },
                'anonymous_memory_limit': {
                    'type': 'integer',
                },
                'dirty_memory_limit': {
                    'type': 'integer',
                },
                'slot': {
                    'type': 'integer',
                    'description':
                        'Number of slots to occupy on a node. Allows limiting total number of pods on a node. Requires special permission to overwrite default value of 1.',
                },
                'network_bandwidth_guarantee': {
                    'type': 'integer',
                    'description': 'In bytes per second.',
                },
                'network_bandwidth_limit': {
                    'type': 'integer',
                },
                'thread_limit': {
                    'type': 'integer',
                    'description':
                        'Pod container thread limit. Requires use permission for pod set node segment attribute /access/scheduling/change_thread_limit.',
                },
                'anon_limit_policy': {
                    'type': 'string',
                    'description':
                        'anon_limit_policy controls gap between memory_limit and anonymous_memory_limit, it must be consistent with anonymous_memory_limit value. Currently anon_limit_policy is supported by YP-lite only and YP-lite users have no ability to change this field value directly with YP API. For details see: SWAT-3782',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Resource Requests',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TScheduling': {
            'properties': {
                'hints': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec.TSchedulingHint',
                    },
                    'type': 'array',
                    'description': 'Hints, that scheduler will take into account during planning of pod allocation.',
                },
                'alert_tolerations': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TAlertToleration',
                    },
                    'type': 'array',
                    'description':
                        'Scheduler will ignore node alerts with types and effects specified in node tolerations.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Scheduling',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TSchedulingHint': {
            'properties': {
                'uuid': {
                    'type': 'string',
                    'description': 'Pod-wise unique identifier. Will be randomly generated if not provided.',
                },
                'creation_time': {
                    'type': 'string',
                    'description': 'Creation time. Will be set to master current time if not provided.',
                    'format': 'date-time',
                },
                'node_id': {
                    'type': 'string',
                    'description':
                        'Node id. Cannot be empty. Allowed to refer to nonexistent node, because it greatly simplifies hints management especially in case of pod copying with concurrent node removal.',
                },
                'strong': {
                    'type': 'boolean',
                    'description':
                        'If true, scheduler must satisfy hint. If false, node from hint is preferred, but not obligated.',
                },
                'source': {
                    'type': 'string',
                    'description':
                        'Identifier of the source of the hint, e.g. "heavy-scheduler". Empty by default. Can be used as a grouping key.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Scheduling Hint',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TSecret': {
            'required': ['secret_id', 'secret_version', 'delegation_token'],
            'properties': {
                'secret_id': {
                    'type': 'string',
                },
                'secret_version': {
                    'type': 'string',
                },
                'delegation_token': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Secret',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TSysctlProperty': {
            'required': ['name', 'value'],
            'properties': {
                'name': {
                    'type': 'string',
                },
                'value': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Sysctl Property',
        },
        'NYP.NClient.NApi.NProto.TPodSpec.TVirtualServiceOptions': {
            'properties': {
                'ip4_mtu': {
                    'type': 'integer',
                },
                'ip6_mtu': {
                    'type': 'integer',
                },
                'decapsulator_anycast_address': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Virtual Service Options',
        },
        'NYP.NClient.NApi.NProto.TPodTemplateSpec': {
            'properties': {
                'spec': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodSpec',
                    'additionalProperties': true,
                },
                'labels': {
                    '$ref': '#/definitions/NYT.NYTree.NProto.TAttributeDictionary',
                    'additionalProperties': true,
                },
                'annotations': {
                    '$ref': '#/definitions/NYT.NYTree.NProto.TAttributeDictionary',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Pod Template Spec',
        },
        'NYP.NClient.NApi.NProto.TRemoveDeployChild': {
            'properties': {
                'fqid': {
                    'type': 'string',
                    'description': 'Fully-qualified id of the child.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Remove Deploy Child',
        },
        'NYP.NClient.NApi.NProto.TRemoveSecretDelegation': {
            'properties': {
                'secret_id': {
                    'type': 'string',
                    'description': 'Secret id assigned by the Vault.',
                },
                'fail_if_already_absent': {
                    'type': 'boolean',
                    'description': 'Report failure (and abort transaction) if the delegation was not found.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Remove Secret Delegation',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetScaleSpec': {
            'properties': {
                'min_replicas': {
                    'type': 'integer',
                    'description':
                        'Lower limit for the number of replicas to which the autoscaler can scale down. Validation: zero value is accepted only if max_replicas is zero',
                },
                'max_replicas': {
                    'type': 'integer',
                    'description':
                        'Upper limit for the number of replicas to which the autoscaler can scale up. Validation - it cannot be less that min_replicas.',
                },
                'cpu': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCPUMetricSpec',
                    'additionalProperties': true,
                    'description': 'deprecated in favor of cpu_utilization',
                },
                'cpu_utilization': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCPUUtilizationMetricSpec',
                    'additionalProperties': true,
                },
                'custom': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCustomMetricSpec',
                    'additionalProperties': true,
                },
                'upscale_delay': {
                    'pattern': '^([0-9]+\\.?[0-9]*|\\.[0-9]+)s$',
                    'type': 'string',
                    'description':
                        'The period since last upscale, before another upscale can be performed in horizontal pod autoscaler. Metric upscale reaction time should be less than specified delay. Otherwise autoscaler would perform several consecutive upscales which may lead to quota shortage. Validation: not less that 5 min Default: 30 min (may change)',
                    'format': 'regex',
                },
                'downscale_delay': {
                    'pattern': '^([0-9]+\\.?[0-9]*|\\.[0-9]+)s$',
                    'type': 'string',
                    'description':
                        'The period since last downscale, before another downscale can be performed in horizontal pod autoscaler. Metric downscale reaction time should be less than specified delay. Otherwise autoscaler would perform several consecutive downscales which may lead to service degradation. Validation: not less that 5 min Default: 60 min (may change)',
                    'format': 'regex',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Replica Set Scale Spec',
            'description':
                'Note that autoscaler does not change replica_set.deployment_strategy (max_unavailable pod count).',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetSpec': {
            'properties': {
                'revision_id': {
                    'type': 'string',
                },
                'replica_count': {
                    'type': 'integer',
                },
                'pod_template_spec': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TPodTemplateSpec',
                    'additionalProperties': true,
                },
                'deployment_strategy': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetSpec.TDeploymentStrategy',
                    'additionalProperties': true,
                },
                'account_id': {
                    'type': 'string',
                },
                'constraints': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetSpec.TConstraints',
                    'additionalProperties': true,
                },
                'node_segment_id': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Replica Set Spec',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetSpec.TConstraints': {
            'properties': {
                'antiaffinity_constraints': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TAntiaffinityConstraint',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Constraints',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetSpec.TDeploymentStrategy': {
            'properties': {
                'min_available': {
                    'type': 'integer',
                },
                'max_unavailable': {
                    'type': 'integer',
                },
                'max_surge': {
                    'type': 'integer',
                },
                'min_created_seconds': {
                    'type': 'integer',
                    'description': 'Minimum number of seconds after pod creation to be considered available.',
                },
                'max_tolerable_downtime_seconds': {
                    'type': 'integer',
                    'description':
                        'Max allowed hardware maintenance duration in seconds during which pods may be unavailable',
                },
                'max_tolerable_downtime_pods': {
                    'type': 'integer',
                    'description': 'max_unavailable analogue, but only for eviction/maintenance-related unavailability',
                },
                'deploy_speed': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeploySpeed',
                    'additionalProperties': true,
                    'description': 'Describes how many pods to update at a time and min delay between updates.',
                },
                'ready_criterion': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployReadyCriterion',
                    'additionalProperties': true,
                    'description': 'Conditions which determine if replica set is ready.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deployment Strategy',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus': {
            'properties': {
                'in_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
                'ready': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
                'revisions': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
                'controller_status': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TControllerStatus',
                    'additionalProperties': true,
                },
                'total_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TDeployProgress',
                    'additionalProperties': true,
                },
                'current_revision_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TDeployProgress',
                    'additionalProperties': true,
                },
                'revisions_progress': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TDeployProgress',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
                'revision_id': {
                    'type': 'string',
                    'title': 'New ReplicaSetStatus schema starts here.',
                    'description': 'New ReplicaSetStatus schema starts here.',
                },
                'in_progress_condition': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCondition',
                    'additionalProperties': true,
                },
                'ready_condition': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCondition',
                    'additionalProperties': true,
                },
                'failed_condition': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCondition',
                    'additionalProperties': true,
                },
                'deploy_status': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TClusterDeployStatus',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Replica Set Status',
            'description':
                'Deprecated fields start here. They will be removed after moving to new ReplicaSetStatus schema.',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition': {
            'properties': {
                'pod_count': {
                    'type': 'integer',
                },
                'condition': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TCondition',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Aggregated Condition',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TCondition': {
            'properties': {
                'status': {
                    'type': 'string',
                },
                'reason': {
                    'type': 'string',
                },
                'message': {
                    'type': 'string',
                },
                'last_transition_time': {
                    'type': 'string',
                    'format': 'date-time',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Condition',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TControllerAttempt': {
            'properties': {
                'succeeded': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TCondition',
                    'additionalProperties': true,
                },
                'revision_id': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Controller Attempt',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TControllerStatus': {
            'properties': {
                'last_attempt': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TControllerAttempt',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Controller Status',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TDeployProgress': {
            'properties': {
                'pods_ready': {
                    'type': 'integer',
                    'description': 'Number of pods synced to up-to-date spec.',
                },
                'pods_in_progress': {
                    'type': 'integer',
                    'description': 'Number of pods currently updating.',
                },
                'pods_total': {
                    'type': 'integer',
                    'description': 'Total number of pods.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Progress',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision': {
            'properties': {
                'revision_id': {
                    'type': 'string',
                },
                'in_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
                'ready': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
                'volumes': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision.TAggregatedVolumeStatus',
                    },
                    'type': 'array',
                },
                'resources': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision.TAggregatedResourceStatus',
                    },
                    'type': 'array',
                },
                'workloads': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision.TAggregatedWorkloadStatus',
                    },
                    'type': 'array',
                },
                'boxes': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision.TAggregatedBoxStatus',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Revision',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision.TAggregatedBoxStatus': {
            'properties': {
                'id': {
                    'type': 'string',
                },
                'in_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
                'ready': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Aggregated Box Status',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision.TAggregatedResourceStatus': {
            'properties': {
                'id': {
                    'type': 'string',
                },
                'in_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
                'ready': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Aggregated Resource Status',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision.TAggregatedVolumeStatus': {
            'properties': {
                'id': {
                    'type': 'string',
                },
                'in_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
                'ready': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Aggregated Volume Status',
        },
        'NYP.NClient.NApi.NProto.TReplicaSetStatus.TRevision.TAggregatedWorkloadStatus': {
            'properties': {
                'id': {
                    'type': 'string',
                },
                'in_progress': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
                'ready': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TReplicaSetStatus.TAggregatedCondition',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Aggregated Workload Status',
        },
        'NYP.NClient.NApi.NProto.TResourceCacheSpec': {
            'properties': {
                'revision': {
                    'type': 'integer',
                },
                'cached_resources': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TResourceCacheSpec.TCachedResource',
                    },
                    'type': 'array',
                },
                'update_window': {
                    'type': 'integer',
                    'description':
                        'Size of the update window in pods TODO(DEPLOY-2795) For backward compatibility, 0 will be interpreted as infinity This will be fixed after the release of the controller and yp schema',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Resource Cache Spec',
        },
        'NYP.NClient.NApi.NProto.TResourceCacheSpec.TCachedResource': {
            'properties': {
                'id': {
                    'type': 'string',
                },
                'layer': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TLayer',
                    'additionalProperties': true,
                },
                'static_resource': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.TResource',
                    'additionalProperties': true,
                },
                'basic_strategy': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TResourceCacheSpec.TResourceCacheBasicStrategy',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Cached Resource',
        },
        'NYP.NClient.NApi.NProto.TResourceCacheSpec.TResourceCacheBasicStrategy': {
            'properties': {
                'max_latest_revisions': {
                    'type': 'integer',
                    'description': 'Number of unique latest revisions to download',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Resource Cache Basic Strategy',
            'description': 'Unique revisions for resource are revisions with different spec of this resource',
        },
        'NYP.NClient.NApi.NProto.TRuntimeDeployControls': {
            'properties': {
                'deploy_unit_approval': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitApproval',
                    'additionalProperties': true,
                },
                'deploy_unit_overrides': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitOverrides',
                    'additionalProperties': true,
                },
                'deploy_unit_approvals': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitApproval',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Runtime Deploy Controls',
        },
        'NYP.NClient.NApi.NProto.TSandboxResourceInfo': {
            'properties': {
                'revision': {
                    'type': 'integer',
                },
                'override': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Sandbox Resource Info',
        },
        'NYP.NClient.NApi.NProto.TSecretRef': {
            'properties': {
                'secret_id': {
                    'type': 'string',
                    'description': 'Object id of the secret (equals its vault id).',
                },
                'secret_version': {
                    'type': 'string',
                    'description': 'Version to retrieve. If empty, retrieve the latest version.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Secret Ref',
            'description': 'Reference to a secret from another object.',
        },
        'NYP.NClient.NApi.NProto.TSidecarVolume': {
            'properties': {
                'storage_class': {
                    'enum': ['AUTO', 'HDD', 'SSD'],
                    'type': 'string',
                    'title': 'E Storage Class',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description':
                '//////////////////////////////////////////////////////////////////////////////  Settings for sidecar disk volume',
        },
        'NYP.NClient.NApi.NProto.TStageControl': {
            'properties': {
                'add_deploy_child': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TAddDeployChild',
                    'additionalProperties': true,
                    'description': 'TODO(deep): extract nested messages and convert to ControlBase',
                },
                'remove_deploy_child': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TRemoveDeployChild',
                    'additionalProperties': true,
                },
                'add_secret_delegation': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TAddSecretDelegation',
                    'additionalProperties': true,
                },
                'remove_secret_delegation': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TRemoveSecretDelegation',
                    'additionalProperties': true,
                },
                'approve': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageControl.TApproveAction',
                    'additionalProperties': true,
                },
                'disapprove': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageControl.TDisapproveAction',
                    'additionalProperties': true,
                },
                'override_deployment_strategy': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageControl.TOverrideDeploymentStrategy',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Stage Control',
            'description': 'Control',
        },
        'NYP.NClient.NApi.NProto.TStageControl.TActionOptions': {
            'properties': {
                'revision': {
                    'type': 'integer',
                },
                'cluster': {
                    'type': 'string',
                },
                'deploy_unit': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Action Options',
        },
        'NYP.NClient.NApi.NProto.TStageControl.TApproveAction': {
            'properties': {
                'options': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageControl.TActionOptions',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Approve Action',
        },
        'NYP.NClient.NApi.NProto.TStageControl.TDisapproveAction': {
            'properties': {
                'options': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageControl.TActionOptions',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Disapprove Action',
        },
        'NYP.NClient.NApi.NProto.TStageControl.TOverrideDeploymentStrategy': {
            'properties': {
                'max_unavailable': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageControl.TOverrideDeploymentStrategy.TDeploymentStrategyValue',
                    'additionalProperties': true,
                },
                'deploy_settings': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageControl.TOverrideDeploymentStrategy.TOverrideDeploySettings',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Override Deployment Strategy',
        },
        'NYP.NClient.NApi.NProto.TStageControl.TOverrideDeploymentStrategy.TDeploySettingValue': {
            'properties': {
                'revision': {
                    'type': 'integer',
                },
                'settings': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec.TDeploySettings',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Setting Value',
        },
        'NYP.NClient.NApi.NProto.TStageControl.TOverrideDeploymentStrategy.TDeploymentStrategyValue': {
            'properties': {
                'deploy_unit_id': {
                    'type': 'string',
                },
                'clusters': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                },
                'revision': {
                    'type': 'integer',
                },
                'value': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deployment Strategy Value',
        },
        'NYP.NClient.NApi.NProto.TStageControl.TOverrideDeploymentStrategy.TOverrideDeploySettings': {
            'properties': {
                'deploy_settings': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageControl.TOverrideDeploymentStrategy.TDeploySettingValue',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Override Deploy Settings',
        },
        'NYP.NClient.NApi.NProto.TStageMeta': {
            'properties': {
                'id': {
                    'type': 'string',
                },
                'uuid': {
                    'type': 'string',
                },
                'name': {
                    'type': 'string',
                },
                'fqid': {
                    'type': 'string',
                },
                'key': {
                    'type': 'string',
                },
                'parent_key': {
                    'type': 'string',
                },
                'account_id': {
                    'type': 'string',
                },
                'effective_account_id': {
                    'type': 'string',
                },
                'type': {
                    'enum': [
                        'OT_NODE',
                        'OT_SCHEMA',
                        'OT_RESOURCE',
                        'OT_POD',
                        'OT_POD_SET',
                        'OT_ENDPOINT',
                        'OT_ENDPOINT_SET',
                        'OT_NETWORK_PROJECT',
                        'OT_NODE_SEGMENT',
                        'OT_VIRTUAL_SERVICE',
                        'OT_USER',
                        'OT_GROUP',
                        'OT_INTERNET_ADDRESS',
                        'OT_IP4_ADDRESS_POOL',
                        'OT_DNS_RECORD_SET',
                        'OT_ACCOUNT',
                        'OT_POD_DISRUPTION_BUDGET',
                        'OT_MAINTENANCE',
                        'OT_WATCH_LOG_CONSUMER',
                        'OT_APPROVAL_POLICY',
                        'OT_DAEMON_SET',
                        'OT_DEPLOY_TICKET',
                        'OT_DNS_ZONE',
                        'OT_DYNAMIC_RESOURCE',
                        'OT_HORIZONTAL_POD_AUTOSCALER',
                        'OT_MULTI_CLUSTER_REPLICA_SET',
                        'OT_NOTIFICATION_INFO',
                        'OT_NOTIFICATION_POLICY',
                        'OT_PERSISTENT_DISK',
                        'OT_PERSISTENT_VOLUME_CLAIM',
                        'OT_PERSISTENT_VOLUME',
                        'OT_PROJECT',
                        'OT_RELATION',
                        'OT_RELEASE',
                        'OT_RELEASE_RULE',
                        'OT_REPLICA_SET',
                        'OT_RESOURCE_CACHE',
                        'OT_SECRET',
                        'OT_SEMAPHORE',
                        'OT_SEMAPHORE_SET',
                        'OT_STAGE_DRAFT',
                        'OT_STAGE',
                        'OT_SYSTEM_SERVICE_CONFIG',
                        'OT_NULL',
                        'OT_NODE2',
                    ],
                    'type': 'string',
                    'title': '//////////////////////////////////////////////////////////////////////////////',
                    'description': '//////////////////////////////////////////////////////////////////////////////',
                },
                'creation_time': {
                    'type': 'integer',
                },
                'inherit_acl': {
                    'type': 'boolean',
                },
                'acl': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TAccessControlEntry',
                    },
                    'type': 'array',
                },
                'project_id': {
                    'type': 'string',
                    'description': 'Custom fields:',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description': '//////////////////////////////////////////////////////////////////////////////',
        },
        'NYP.NClient.NApi.NProto.TStageSpec': {
            'properties': {
                'revision': {
                    'type': 'integer',
                    'description': 'Should be incremented on any update.',
                },
                'deploy_units': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitSpec',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': '\u003cunit id\u003e -\u003e \u003cunit spec\u003e.',
                },
                'account_id': {
                    'type': 'string',
                    'description': 'In form "abc:service:\u003cint id\u003e".',
                },
                'dynamic_resources': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageSpec.TStageDynamicResourceSpec',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': '\u003cdynamic resource id\u003e -\u003e \u003cdynamic resource info\u003e',
                },
                'revision_info': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageSpec.TRevisionInfo',
                    'additionalProperties': true,
                    'description':
                        'Information about current revision of the spec. NOTE: see https://st.yandex-team.ru/YP-1270 for api support.',
                },
                'sox_service': {
                    'type': 'boolean',
                },
                'resource_caches': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageSpec.TStageResourceCacheSpec',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': '\u003cresource cache id\u003e -\u003e \u003cresource cache info\u003e',
                },
                'env': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description':
                        'Environment variables applied to all stage boxes/workloads. Boxes/workloads are able to override those global variables.',
                },
                'disable_automatic_secret_delegation': {
                    'type': 'boolean',
                    'description': 'Disable automatic addition of secret delegations to the stage.',
                },
                'deploy_unit_settings': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageSpec.TDeployUnitSettings',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description':
                        '\u003cdeploy unit id\u003e -\u003e \u003csettings\u003e. This settings do not affect to deploy unit revision.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Stage Spec',
        },
        'NYP.NClient.NApi.NProto.TStageSpec.TDeployUnitSettings': {
            'properties': {
                'alerting': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageSpec.TDeployUnitSettings.TAlerting',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Deploy Unit Settings',
        },
        'NYP.NClient.NApi.NProto.TStageSpec.TDeployUnitSettings.TAlerting': {
            'properties': {
                'state': {
                    'enum': ['UNKNOWN', 'ENABLED', 'IDLE', 'REMOVED'],
                    'type': 'string',
                    'title': 'E State',
                },
                'notification_channels': {
                    'additionalProperties': {
                        'type': 'string',
                    },
                    'type': 'object',
                    'description':
                        '\u003calert status\u003e - \u003cnotification_channel\u003e. Distribute notifications to different channels depending on alert status.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Alerting',
        },
        'NYP.NClient.NApi.NProto.TStageSpec.TRevisionInfo': {
            'properties': {
                'description': {
                    'type': 'string',
                    'description': 'Human-readable description.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Revision Info',
        },
        'NYP.NClient.NApi.NProto.TStageSpec.TStageDynamicResourceSpec': {
            'properties': {
                'deploy_unit_ref': {
                    'type': 'string',
                },
                'dynamic_resource': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDynamicResourceSpec',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Stage Dynamic Resource Spec',
        },
        'NYP.NClient.NApi.NProto.TStageSpec.TStageResourceCacheSpec': {
            'properties': {
                'deploy_unit_ref': {
                    'type': 'string',
                },
                'resource_cache': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TResourceCacheSpec',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Stage Resource Cache Spec',
        },
        'NYP.NClient.NApi.NProto.TStageStatus': {
            'properties': {
                'deploy_units': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDeployUnitStatus',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description': '\u003cunit id\u003e -\u003e \u003cunit status\u003e.',
                },
                'revision': {
                    'type': 'integer',
                    'description':
                        'Revision of spec last treated by controller. Other stage-wide status fields refer to this revision. Unit specs may refer to other revisions, as specified inside them.',
                },
                'validated': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TCondition',
                    'additionalProperties': true,
                    'description': 'Stage spec has been accepted by controller as valid.',
                },
                'spec_timestamp': {
                    'type': 'integer',
                    'description': 'YP timestamp of spec last treated by controller.',
                },
                'dynamic_resources': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageStatus.TStageDynamicResourceStatus',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description':
                        '\u003cresource id\u003e -\u003e \u003caggregated from clusters resource status\u003e',
                },
                'resource_caches': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageStatus.TStageResourceCacheStatus',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                    'description':
                        '\u003cresource cache id\u003e -\u003e \u003caggregated from clusters resource status\u003e',
                },
                'runtime_deploy_controls': {
                    'additionalProperties': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TRuntimeDeployControls',
                        'additionalProperties': true,
                    },
                    'type': 'object',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Stage Status',
        },
        'NYP.NClient.NApi.NProto.TStageStatus.TStageDynamicResourceStatus': {
            'properties': {
                'status': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDynamicResourceStatus.TRevisionStatus',
                    'additionalProperties': true,
                },
                'current_target': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageSpec.TStageDynamicResourceSpec',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Stage Dynamic Resource Status',
        },
        'NYP.NClient.NApi.NProto.TStageStatus.TStageResourceCacheStatus': {
            'properties': {
                'current_target': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageSpec.TStageResourceCacheSpec',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Stage Resource Cache Status',
        },
        'NYP.NClient.NApi.NProto.TTvmApp': {
            'properties': {
                'app_id': {
                    'type': 'integer',
                },
                'alias': {
                    'type': 'string',
                },
                'abc_service_id': {
                    'type': 'string',
                    'description':
                        'ABC service to which this app is assigned. Used only as metadata to be displayed in GUI/yaml.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'TVM',
            'description': 'TVM  https://wiki.yandex-team.ru/passport/tvm2/abc/',
        },
        'NYP.NClient.NApi.NProto.TTvmClient': {
            'properties': {
                'secret_selector': {
                    '$ref': '#/definitions/NInfra.NPodAgent.API.SecretSelector',
                    'additionalProperties': true,
                    'description':
                        "secret_selector is used for generating secret env var with predefined name TVM_CLIENT_SECRET. TVM_CLIENT_SECRET env var is written to tvmtool's workload spec only and used for generating tvmtool config. Also secret_selector.alias is the key of secret in TPodSpec.secrets.",
                },
                'source': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TTvmApp',
                    'additionalProperties': true,
                },
                'destinations': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TTvmApp',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Tvm Client',
        },
        'NYP.NClient.NApi.NProto.TTvmConfig': {
            'properties': {
                'mode': {
                    'enum': ['UNKNOWN', 'DISABLED', 'ENABLED'],
                    'type': 'string',
                    'title': 'E Mode',
                },
                'blackbox_environment': {
                    'type': 'string',
                    'description':
                        'Blackbox instances to check tickets. See https://wiki.yandex-team.ru/passport/tvm2/tvm-daemon/#opisanieformatakonfiganajsonschema for available values.',
                },
                'clients': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NApi.NProto.TTvmClient',
                    },
                    'type': 'array',
                },
                'client_port': {
                    'type': 'integer',
                    'description':
                        'Port number on which tvmtool listens. It binds to loopback interface only. If unset, port 2 will be used - https://wiki.yandex-team.ru/deploy/docs/#portyvpodezanjatyeinfrastrukturojj.',
                },
                'tvmtool_layer': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TDownloadableResource',
                    'additionalProperties': true,
                    'description': 'Custom tvmtool layer. For development purposes only.',
                },
                'cpu_limit': {
                    'type': 'integer',
                    'description': 'Box CPU limit 1 = 0.001',
                },
                'memory_limit_mb': {
                    'type': 'integer',
                    'description': 'Box Memory limit mebibyte',
                },
                'stage_tvm_id': {
                    'type': 'integer',
                    'description': 'Solomon section',
                },
                'solomon_tvm_id': {
                    'type': 'integer',
                },
                'monitoring_port': {
                    'type': 'integer',
                },
                'sidecar_volume': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TSidecarVolume',
                    'additionalProperties': true,
                    'description': 'Disk volume settings for sidecar',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Tvm Config',
            'description':
                'Config for tvmtool. See https://wiki.yandex-team.ru/deploy/docs/sidecars/tvmtool for details.',
        },
        'NYP.NClient.NHQ.NProto.ComputeResource': {
            'properties': {
                'name': {
                    'type': 'string',
                    'description': 'Resource name, e.g. "cpu", "ram"...',
                },
                'type': {
                    'enum': ['SCALAR'],
                    'type': 'string',
                    'title': 'Type',
                },
                'scalar': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Scalar',
                    'additionalProperties': true,
                    'description': 'Value of resource',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Compute Resource',
            'description': 'Compute resource description',
        },
        'NYP.NClient.NHQ.NProto.Container': {
            'properties': {
                'name': {
                    'type': 'string',
                    'description':
                        'option (message_schema.description) = "Container (section) description";  [(field_schema.title) = "Name of container (section)", (field_schema.required) = true];',
                },
                'env': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.EnvVar',
                    },
                    'type': 'array',
                    'description': '[(field_schema.title) = "Environment variables configuration"];',
                },
                'command': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description': '[(field_schema.title) = "Command to run in container"];',
                },
                'readiness_probe': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Probe',
                    'additionalProperties': true,
                    'description': '[(field_schema.title) = "How to check container readiness"];',
                },
                'restart_policy': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.RestartPolicy',
                    'additionalProperties': true,
                },
                'lifecycle': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Lifecycle',
                    'additionalProperties': true,
                },
                'resource_allocation': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.ResourceAllocation',
                    'additionalProperties': true,
                },
                'security_context': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.SecurityContext',
                    'additionalProperties': true,
                },
                'reopen_log_action': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.ReopenLogAction',
                    'additionalProperties': true,
                },
                'coredump_policy': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.CoredumpPolicy',
                    'additionalProperties': true,
                },
                'cpu_policy': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.CpuPolicy',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Container',
        },
        'NYP.NClient.NHQ.NProto.CoredumpAggregator': {
            'properties': {
                'type': {
                    'enum': ['DISABLED', 'SAAS_AGGREGATOR'],
                    'type': 'string',
                    'title': 'Type',
                },
                'saas': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.SaasCoredumpAggregator',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Coredump Aggregator',
        },
        'NYP.NClient.NHQ.NProto.CoredumpAggregatorGdb': {
            'properties': {
                'exec_path': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Coredump Aggregator Gdb',
        },
        'NYP.NClient.NHQ.NProto.CoredumpCleanupPolicy': {
            'properties': {
                'type': {
                    'enum': ['DISABLED', 'TTL'],
                    'type': 'string',
                    'title': 'Type',
                },
                'ttl': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.CoredumpCleanupPolicyTtl',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Coredump Cleanup Policy',
        },
        'NYP.NClient.NHQ.NProto.CoredumpCleanupPolicyTtl': {
            'properties': {
                'seconds': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Coredump Cleanup Policy Ttl',
        },
        'NYP.NClient.NHQ.NProto.CoredumpPolicy': {
            'properties': {
                'type': {
                    'enum': ['NONE', 'COREDUMP', 'CUSTOM_CORE_COMMAND'],
                    'type': 'string',
                    'title': 'Type',
                },
                'coredump_processor': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.CoredumpProcessor',
                    'additionalProperties': true,
                },
                'custom_processor': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.CustomCommandCoredumpProcessor',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Coredump Policy',
        },
        'NYP.NClient.NHQ.NProto.CoredumpProcessor': {
            'properties': {
                'path': {
                    'type': 'string',
                },
                'count_limit': {
                    'type': 'integer',
                },
                'total_size_limit': {
                    'type': 'integer',
                },
                'probability': {
                    'type': 'integer',
                },
                'aggregator': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.CoredumpAggregator',
                    'additionalProperties': true,
                },
                'cleanup_policy': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.CoredumpCleanupPolicy',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Coredump Processor',
        },
        'NYP.NClient.NHQ.NProto.CpuPolicy': {
            'properties': {
                'type': {
                    'enum': ['normal', 'high', 'batch', 'idle', 'rt'],
                    'type': 'string',
                    'title': 'Type',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Cpu Policy',
        },
        'NYP.NClient.NHQ.NProto.CustomCommandCoredumpProcessor': {
            'properties': {
                'command': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Custom Command Coredump Processor',
        },
        'NYP.NClient.NHQ.NProto.EnvVar': {
            'properties': {
                'name': {
                    'type': 'string',
                    'description':
                        'option (message_schema.description) = "Environment variable for process";  [(field_schema.title) = "Environment variable name", (field_schema.required) = true];',
                },
                'value_from': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.EnvVarSource',
                    'additionalProperties': true,
                    'description': '[(field_schema.title) = "Take variable value from this"];',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Env Var',
        },
        'NYP.NClient.NHQ.NProto.EnvVarSource': {
            'properties': {
                'type': {
                    'enum': ['SECRET_ENV', 'VAULT_SECRET_ENV', 'LITERAL_ENV'],
                    'type': 'string',
                    'title': 'Source Type',
                    'description':
                        'option (message_schema.description) = "Source from which to set process environment variable";',
                },
                'secret_env': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.SecretEnvSelector',
                    'additionalProperties': true,
                    'description': '[(field_schema.title) = "Set variable from NannyVault secrets storage"];',
                },
                'vault_secret_env': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.VaultSecretEnvSelector',
                    'additionalProperties': true,
                    'description': '[(field_schema.title) = "Set variable from YaVault secrets storage"];',
                },
                'literal_env': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.LiteralEnvSelector',
                    'additionalProperties': true,
                    'description': '[(field_schema.title) = "Set variable equal to literal value"];',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Env Var Source',
        },
        'NYP.NClient.NHQ.NProto.ExecAction': {
            'properties': {
                'command': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Exec Action',
        },
        'NYP.NClient.NHQ.NProto.HTTPGetAction': {
            'properties': {
                'path': {
                    'type': 'string',
                    'description': 'Path to access on the HTTP server.',
                },
                'port': {
                    'type': 'string',
                    'description': 'Name or number of the port to access on the container.',
                },
                'host': {
                    'type': 'string',
                    'description':
                        'Host name to connect to, defaults to the container IP. You probably want to set "Host" in httpHeaders instead.',
                },
                'uri_scheme': {
                    'type': 'string',
                    'description': 'Scheme to use for connecting to the host, defaults to HTTP.',
                },
                'http_headers': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.HTTPHeader',
                    },
                    'type': 'array',
                    'description': 'Custom headers to set in the request. HTTP allows repeated headers.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'HTTP Get Action',
        },
        'NYP.NClient.NHQ.NProto.HTTPHeader': {
            'properties': {
                'name': {
                    'type': 'string',
                    'description': 'The header field name',
                },
                'value': {
                    'type': 'string',
                    'description': 'The header field value',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'HTTP Header',
            'description': 'HTTPHeader describes a custom header to be used in HTTP probes',
        },
        'NYP.NClient.NHQ.NProto.Handler': {
            'properties': {
                'type': {
                    'enum': ['NONE', 'EXEC', 'TCP_SOCKET', 'HTTP_GET'],
                    'type': 'string',
                    'title': 'Handler Type',
                },
                'exec_action': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.ExecAction',
                    'additionalProperties': true,
                    'description': 'Exec specifies the action to take.',
                },
                'http_get': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.HTTPGetAction',
                    'additionalProperties': true,
                    'description': 'HTTPGet specifies the http request to perform.',
                },
                'tcp_socket': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.TCPSocketAction',
                    'additionalProperties': true,
                    'description': 'TCPSocket specifies an action involving a TCP port.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Handler',
            'description': 'Handler defines a specific action that should be taken',
        },
        'NYP.NClient.NHQ.NProto.InstanceRevision': {
            'properties': {
                'id': {
                    'type': 'string',
                    'description': 'Unique identifier',
                },
                'target': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.RevisionTargetStatus',
                    'additionalProperties': true,
                    'description': 'Target state',
                },
                'container': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Container',
                    },
                    'type': 'array',
                    'description': 'Containers definitions',
                },
                'volume': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Volume',
                    },
                    'type': 'array',
                    'description': 'Volumes definitions',
                },
                'tags': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                    'description': 'Oldstyle gencfg instance tags',
                },
                'shard_name': {
                    'type': 'string',
                    'description': 'Shard name from gencfg (see JUGGLER-2402 for details)',
                },
                'init_containers': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Container',
                    },
                    'type': 'array',
                    'description':
                        '[(field_schema.title) = "Instance init containers (will be run before instance start)"];',
                },
                'type': {
                    'enum': ['NO_SUBCONTAINERS', 'APP_CONTAINER', 'OS_CONTAINER'],
                    'type': 'string',
                    'title': 'Instance Type',
                },
                'work_dir': {
                    'type': 'string',
                },
                'notify_action': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.NotifyAction',
                    'additionalProperties': true,
                },
                'hostname': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Instance Revision',
            'description': 'Describes instance revision',
        },
        'NYP.NClient.NHQ.NProto.ItsVolume': {
            'properties': {
                'its_url': {
                    'type': 'string',
                },
                'period_seconds': {
                    'type': 'integer',
                    'description': 'Poll period (in seconds)',
                },
                'max_retry_period_seconds': {
                    'type': 'integer',
                    'description': 'Max retry period (in seconds)',
                },
                'use_shared_memory': {
                    'type': 'boolean',
                    'description': 'Symlink volume to /dev/shm',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Its Volume',
        },
        'NYP.NClient.NHQ.NProto.KeychainSecret': {
            'properties': {
                'keychain_id': {
                    'type': 'string',
                },
                'secret_id': {
                    'type': 'string',
                },
                'secret_revision_id': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Keychain Secret',
        },
        'NYP.NClient.NHQ.NProto.Lifecycle': {
            'properties': {
                'pre_stop': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Handler',
                    'additionalProperties': true,
                },
                'stop_grace_period_seconds': {
                    'type': 'integer',
                    'description': 'Time after pre_stop handler has been executed before sending TERM signal',
                },
                'termination_grace_period_seconds': {
                    'type': 'integer',
                    'description': 'Time after TERM signal sent before sending KILL signal',
                },
                'term_barrier': {
                    'enum': ['IGNORE', 'WAIT'],
                    'type': 'string',
                    'title': 'Term Barrier',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Lifecycle',
        },
        'NYP.NClient.NHQ.NProto.LiteralEnvSelector': {
            'properties': {
                'value': {
                    'type': 'string',
                    'description':
                        'option (message_schema.description) = "Set process environment variable equal to literal value";  [(field_schema.title) = "Literal value to set"];',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Literal Env Selector',
        },
        'NYP.NClient.NHQ.NProto.NotifyAction': {
            'properties': {
                'handlers': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Handler',
                    },
                    'type': 'array',
                },
                'resource_allocation': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.ResourceAllocation',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Notify Action',
        },
        'NYP.NClient.NHQ.NProto.Port': {
            'properties': {
                'name': {
                    'type': 'string',
                    'description': 'Port name, e.g. "rpc" or "web".',
                },
                'port': {
                    'type': 'integer',
                    'description': 'Port value',
                },
                'protocol': {
                    'type': 'string',
                    'description': 'Port protocol, one of: "TCP" or "UDP".',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Port',
            'description': 'Allocated port used by instance',
        },
        'NYP.NClient.NHQ.NProto.Probe': {
            'properties': {
                'handlers': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Handler',
                    },
                    'type': 'array',
                },
                'initial_delay_seconds': {
                    'type': 'integer',
                    'description': 'Length of time before health checking is activated. In seconds.',
                },
                'min_period_seconds': {
                    'type': 'integer',
                    'description': 'Min period (in seconds)',
                },
                'max_period_seconds': {
                    'type': 'integer',
                    'description': 'Max period (in seconds)',
                },
                'period_backoff': {
                    'type': 'integer',
                    'description': 'Period backoff',
                },
                'success_threshold': {
                    'type': 'integer',
                    'description':
                        'Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness.',
                },
                'failure_threshold': {
                    'type': 'integer',
                    'description':
                        'Minimum consecutive failures for the probe to be considered failed after having succeeded.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Probe',
        },
        'NYP.NClient.NHQ.NProto.ReopenLogAction': {
            'properties': {
                'handler': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Handler',
                    'additionalProperties': true,
                },
                'resource_allocation': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.ResourceAllocation',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Reopen Log Action',
        },
        'NYP.NClient.NHQ.NProto.ResourceAllocation': {
            'properties': {
                'limit': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.ComputeResource',
                    },
                    'type': 'array',
                    'description': 'Maximum allowed resource consumption',
                },
                'request': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.ComputeResource',
                    },
                    'type': 'array',
                    'description': 'Minimum guaranteed resources',
                },
                'port': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Port',
                    },
                    'type': 'array',
                    'description': 'Allocated ports for instance',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Resource Allocation',
            'description':
                'Instance resource allocation received from resource requirement for particular instance on a node',
        },
        'NYP.NClient.NHQ.NProto.RestartPolicy': {
            'properties': {
                'type': {
                    'enum': ['ALWAYS', 'ON_FAILURE', 'NEVER'],
                    'type': 'string',
                    'title': 'Restart Policy Type',
                },
                'min_period_seconds': {
                    'type': 'integer',
                    'description': 'Min period (in seconds)',
                },
                'max_period_seconds': {
                    'type': 'integer',
                    'description': 'Max period (in seconds)',
                },
                'period_backoff': {
                    'type': 'integer',
                    'description': 'Period backoff',
                },
                'period_jitter_seconds': {
                    'type': 'integer',
                    'description': 'Period jitter seconds',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Restart Policy',
        },
        'NYP.NClient.NHQ.NProto.RevisionTargetStatus': {
            'properties': {
                'status': {
                    'type': 'string',
                    'description': 'One of: "Active", "Prepared"',
                },
                'last_modification_time': {
                    'type': 'string',
                    'format': 'date-time',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Revision Target Status',
            'description': 'Status in which revision should be present on a node in a cluster',
        },
        'NYP.NClient.NHQ.NProto.SaasCoredumpAggregator': {
            'properties': {
                'url': {
                    'type': 'string',
                },
                'service_name': {
                    'type': 'string',
                },
                'gdb': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.CoredumpAggregatorGdb',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Saas Coredump Aggregator',
        },
        'NYP.NClient.NHQ.NProto.Scalar': {
            'properties': {
                'value': {
                    'type': 'integer',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Scalar',
            'description': 'Scalar resource value',
        },
        'NYP.NClient.NHQ.NProto.SecretEnvSelector': {
            'properties': {
                'secret_name': {
                    'type': 'string',
                    'description':
                        'option (nanny.schema.description) = "Source to set process environment variable from Vault secret";  [(field_schema.title) = "Vault secret name"];',
                },
                'field': {
                    'type': 'string',
                    'description': '[(field_schema.title) = "Field to extract from secret"];',
                },
                'keychain_secret': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.KeychainSecret',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Secret Env Selector',
        },
        'NYP.NClient.NHQ.NProto.SecretVolume': {
            'properties': {
                'secret_name': {
                    'type': 'string',
                    'description': '[(field_schema.title) = "NannyVault secret name"];',
                },
                'keychain_secret': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.KeychainSecret',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Secret Volume',
        },
        'NYP.NClient.NHQ.NProto.SecurityContext': {
            'properties': {
                'capabilities': {
                    'items': {
                        'type': 'string',
                    },
                    'type': 'array',
                },
                'run_as_user': {
                    'type': 'string',
                },
                'porto_access_policy': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Security Context',
        },
        'NYP.NClient.NHQ.NProto.TCPSocketAction': {
            'properties': {
                'port': {
                    'type': 'string',
                    'description': 'Port to connect to.',
                },
                'host': {
                    'type': 'string',
                    'description': 'Host name to connect to, defaults to the container IP.',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'TCP Socket Action',
        },
        'NYP.NClient.NHQ.NProto.Template': {
            'properties': {
                'src_path': {
                    'type': 'string',
                },
                'dst_path': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Template',
        },
        'NYP.NClient.NHQ.NProto.TemplateVolume': {
            'properties': {
                'template': {
                    'items': {
                        '$ref': '#/definitions/NYP.NClient.NHQ.NProto.Template',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Template Volume',
        },
        'NYP.NClient.NHQ.NProto.VaultSecret': {
            'properties': {
                'secret_name': {
                    'type': 'string',
                },
                'secret_id': {
                    'type': 'string',
                },
                'secret_ver': {
                    'type': 'string',
                },
                'delegation_token': {
                    'type': 'string',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Vault Secret',
        },
        'NYP.NClient.NHQ.NProto.VaultSecretEnvSelector': {
            'properties': {
                'field': {
                    'type': 'string',
                    'description': '[(field_schema.title) = "Field to extract from YaVault secret"];',
                },
                'vault_secret': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.VaultSecret',
                    'additionalProperties': true,
                    'description': '[(field_schema.title) = "YaVault secret"];',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Vault Secret Env Selector',
        },
        'NYP.NClient.NHQ.NProto.VaultSecretVolume': {
            'properties': {
                'vault_secret': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.VaultSecret',
                    'additionalProperties': true,
                    'description': '[(field_schema.title) = "YaVault secret"];',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Vault Secret Volume',
        },
        'NYP.NClient.NHQ.NProto.Volume': {
            'properties': {
                'name': {
                    'type': 'string',
                },
                'version': {
                    'type': 'string',
                },
                'type': {
                    'enum': ['SECRET', 'TEMPLATE', 'ITS', 'VAULT_SECRET'],
                    'type': 'string',
                    'title': 'Volume Source Type',
                },
                'secret_volume': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.SecretVolume',
                    'additionalProperties': true,
                },
                'vault_secret_volume': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.VaultSecretVolume',
                    'additionalProperties': true,
                },
                'template_volume': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.TemplateVolume',
                    'additionalProperties': true,
                },
                'its_volume': {
                    '$ref': '#/definitions/NYP.NClient.NHQ.NProto.ItsVolume',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'Volume',
        },
        'NYT.NYTree.NProto.TAttribute': {
            'required': ['key', 'value'],
            'properties': {
                'key': {
                    'type': 'string',
                },
                'value': {
                    'type': 'string',
                    'format': 'binary',
                    'binaryEncoding': 'base64',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': '//////////////////////////////////////////////////////////////////////////////',
            'description': '//////////////////////////////////////////////////////////////////////////////',
        },
        'NYT.NYTree.NProto.TAttributeDictionary': {
            'properties': {
                'attributes': {
                    'items': {
                        '$ref': '#/definitions/NYT.NYTree.NProto.TAttribute',
                    },
                    'type': 'array',
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Attribute Dictionary',
        },
        'TStage': {
            'properties': {
                'meta': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageMeta',
                    'additionalProperties': true,
                },
                'spec': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageSpec',
                    'additionalProperties': true,
                },
                'status': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageStatus',
                    'additionalProperties': true,
                },
                'labels': {
                    '$ref': '#/definitions/NYT.NYTree.NProto.TAttributeDictionary',
                    'additionalProperties': true,
                },
                'annotations': {
                    '$ref': '#/definitions/NYT.NYTree.NProto.TAttributeDictionary',
                    'additionalProperties': true,
                },
                'control': {
                    '$ref': '#/definitions/NYP.NClient.NApi.NProto.TStageControl',
                    'additionalProperties': true,
                },
            },
            'additionalProperties': true,
            'type': 'object',
            'title': 'T Stage',
        },
    },
};
