import { ComponentMeta, Story } from '@storybook/react';
import { useEffect, useRef, useState } from 'react';

import { YamlEditor, YamlEditorProps } from '../YamlEditor';
import { registerYamlJSONSchema } from '../registerYamlLanguage';
import { stageSchema } from './TStage';
import { MonacoEditorStatusLine } from '../../MonacoEditorStatusLine';
import { EditorRef } from '../../../models';

import classes from './YamlEditor.stories.module.css';

const Template: Story<YamlEditorProps> = ({ ...props }) => {
    const [value, setValue] = useState(props.value);

    useEffect(() => {
        (async () => {
            await registerYamlJSONSchema({
                schemaSettings: {
                    fileMatch: [`monaco://schema.yaml/*`], // all by prefix
                    uri: 'monaco://schema.yaml/stage',
                    schema: stageSchema as any,
                },
            });
            console.log(`schema registered monaco://schema.yaml/stage`);
        })();
    }, []);

    const editorRef = useRef<EditorRef | null>(null);
    const showStatusLine = Boolean(props.uri);

    return (
        <div style={{ height: '90vh' }}>
            <YamlEditor
                {...props}
                value={value}
                onUpdate={setValue}
                className={classes.editor}
                forwardedRef={editorRef}
                placeholder={'input yaml text'}
                showBorder={!showStatusLine}
            />
            {showStatusLine && <MonacoEditorStatusLine editorRef={editorRef} />}
        </div>
    );
};

export const Default = Template.bind({});
Default.args = {
    value: `l7_upstream_macro:
  version: 0.0.1
  id: pre-deploy-ui
  matcher:
    host_re: pre-ui.deploy.yandex-team.ru
  flat_scheme:
    balancer:
      compat:
        method: RR
        watermark_policy:
          lo: 0.1
          hi: 0.1
      attempts: 3
      retry_http_responses:
        codes: [5xx]
      connect_timeout: 70ms
      backend_timeout: 60s
    backend_ids:
      - pre-deploy-ui
    on_error:
      rst: true`,
};

export const ReadOnly = Template.bind({});
ReadOnly.args = {
    readonly: true,
    value: `l7_upstream_macro:
  version: 0.0.1
  id: pre-deploy-ui`,
};

const stageYaml = `spec:
  account_id: abc:service:3494
  revision: 97
  deploy_units:
    parallel-strategy:
      network_defaults:
        network_id: _SEARCHSAND_
      endpoint_sets:
        - port: 80
      revision: 17
      replica_set:
        replica_set_template:
          pod_template_spec:
            spec:
              resource_requests:
                vcpu_guarantee: 100
                vcpu_limit: 100
                memory_guarantee: 1073741824
                memory_limit: 1073741824
                network_bandwidth_guarantee: 31457280
                network_bandwidth_limit: 31457280
              disk_volume_requests:
                - id: disk-0
                  labels:
                    used_by_infra: true
                  storage_class: hdd
                  quota_policy:
                    capacity: 3221225472
                    bandwidth_guarantee: 15728640
                    bandwidth_limit: 31457280
              pod_agent_payload:
                spec:
                  resources:
                    layers:
                      - id: layer
                        checksum: 'EMPTY:'
                        url: rbtorrent:49969bbdbc58134227a8e3276e92d843f0f904b2
                      - id: simple_http_server
                        checksum: 'EMPTY:'
                        url: rbtorrent:d57bb5d384702469a420e497ac67d8c14986277f
                  workloads:
                    - id: workload
                      readiness_check:
                        tcp_check:
                          port: 80
                      box_ref: box
                      start:
                        command_line: /simple_http_server 80 'Hel lo my dear @nikolaichev!'
                  boxes:
                    - id: box
                      rootfs:
                        layer_refs:
                          - layer
                          - simple_http_server
                        create_mode: read_only
                      cgroup_fs_mount_mode: ro
                  mutable_workloads:
                    - workload_ref: workload
          constraints:
            antiaffinity_constraints:
              - key: rack
                max_pods: 1
        per_cluster_settings:
          man:
            pod_count: 1
            deployment_strategy:
              max_unavailable: 1
          sas:
            pod_count: 3
            deployment_strategy:
              max_unavailable: 1
      pod_agent_sandbox_info:
        revision: 2882369236
      logbroker_tools_sandbox_info:
        revision: 2249562029
      deploy_settings:
        cluster_sequence:
          - yp_cluster: sas
            need_approval: true
          - yp_cluster: man
        deploy_strategy: parallel
      patchers_revision: 11
    sequential-strategy:
      network_defaults:
        network_id: _SEARCHSAND_
      endpoint_sets:
        - port: 80
      revision: 23
      replica_set:
        replica_set_template:
          pod_template_spec:
            spec:
              resource_requests:
                vcpu_guarantee: 100
                vcpu_limit: 100
                memory_guarantee: 1073741824
                memory_limit: 1073741824
                network_bandwidth_guarantee: 31457280
                network_bandwidth_limit: 31457280
              disk_volume_requests:
                - id: disk-0
                  labels:
                    used_by_infra: true
                  storage_class: hdd
                  quota_policy:
                    capacity: 3221225472
                    bandwidth_guarantee: 15728640
                    bandwidth_limit: 31457280
              pod_agent_payload:
                spec:
                  resources:
                    layers:
                      - id: layer
                        checksum: 'EMPTY:'
                        url: rbtorrent:49969bbdbc58134227a8e3276e92d843f0f904b2
                      - id: simple_http_server
                        checksum: 'EMPTY:'
                        url: rbtorrent:d57bb5d384702469a420e497ac67d8c14986277f
                  workloads:
                    - id: workload
                      readiness_check:
                        tcp_check:
                          port: 80
                      box_ref: box
                      start:
                        command_line: /simple_http_server 80 'Hel lo my dear @nikolaichev!'
                      transmit_logs: true
                  boxes:
                    - id: box
                      rootfs:
                        layer_refs:
                          - layer
                          - simple_http_server
                        create_mode: read_only
                      cgroup_fs_mount_mode: ro
                  mutable_workloads:
                    - workload_ref: workload
              host_infra:
                monitoring:
                  workloads:
                    - labels:
                        itype: deploy-ui
                      workload_id: workload
          constraints:
            antiaffinity_constraints:
              - key: rack
                max_pods: 1
        per_cluster_settings:
          man:
            pod_count: 1
            deployment_strategy:
              max_unavailable: 1
          sas:
            pod_count: 2
            deployment_strategy:
              max_unavailable: 1
      coredump_config:
        workload:
          coredump_processor:
            count_limit: 2
            total_size_limit_megabytes: 500
            probability: 100
            aggregator: {}
            output: ''
      pod_agent_sandbox_info:
        revision: 2882369236
      logbroker_tools_sandbox_info:
        revision: 2739742779
      deploy_settings:
        cluster_sequence:
          - yp_cluster: man
            need_approval: true
          - yp_cluster: sas
            need_approval: true
      patchers_revision: 11
    deployUnit_MCRS:
      network_defaults:
        network_id: _SEARCHSAND_
      endpoint_sets:
        - port: 80
      revision: 28
      multi_cluster_replica_set:
        replica_set:
          pod_template_spec:
            spec:
              resource_requests:
                vcpu_guarantee: 100
                vcpu_limit: 100
                memory_guarantee: 1073741824
                memory_limit: 1073741824
                network_bandwidth_guarantee: 31457280
                network_bandwidth_limit: 31457280
              disk_volume_requests:
                - id: disk-0
                  labels:
                    used_by_infra: true
                  storage_class: hdd
                  quota_policy:
                    capacity: 3221225472
                    bandwidth_guarantee: 15728640
                    bandwidth_limit: 31457280
              pod_agent_payload:
                spec:
                  resources:
                    layers:
                      - id: layer
                        checksum: 'EMPTY:'
                        url: rbtorrent:49969bbdbc58134227a8e3276e92d843f0f904b2
                      - id: simple_http_server
                        checksum: 'EMPTY:'
                        url: rbtorrent:d57bb5d384702469a420e497ac67d8c14986277f
                  workloads:
                    - id: workload
                      readiness_check:
                        tcp_check:
                          port: 80
                      box_ref: box
                      start:
                        command_line: /simple_http_server 80 'Hello my dear @nikolaichev!'
                      transmit_logs: true
                  boxes:
                    - id: box
                      rootfs:
                        layer_refs:
                          - layer
                          - simple_http_server
                  mutable_workloads:
                    - workload_ref: workload
              host_infra:
                monitoring:
                  unistats:
                    - labels:
                        itype: deploy-ui
                      workload_id: workload
                    - path: /test
                      workload_id: workload
                  workloads:
                    - labels:
                        itype: deploy-ui
                      workload_id: workload
          deployment_strategy:
            max_unavailable: 2
            max_tolerable_downtime_pods: 1
          clusters:
            - cluster: man
              spec:
                replica_count: 1
            - cluster: sas
              spec:
                replica_count: 2
            - cluster: iva
              spec:
                replica_count: 1
            - cluster: myt
              spec:
                replica_count: 1
      coredump_config:
        workload:
          coredump_processor:
            count_limit: 2
            total_size_limit_megabytes: 500
            probability: 100
            aggregator: {}
            output: ''
      pod_agent_sandbox_info:
        revision: 2882369236
      logbroker_tools_sandbox_info:
        revision: 2739742779
      patchers_revision: 11
  revision_info: {}
  infra_components: {}
meta:
  effective_account_id: null
  fqid: >-
    yp|xdc|stage|nikolaichev-stage-per-location|8b9ec6fb-d32ce6b8-1fc4930d-72e833dc
  inherit_acl: true
  type: stage
  project_id: nikolaichev-test
  id: nikolaichev-stage-per-location
  parent_key: ''
  creation_time: 1614259428549140
  acl:
    - action: allow
      permissions:
        - read
        - read_secrets
        - write
        - create
        - ssh_access
        - root_ssh_access
      subjects:
        - robot-drug-deploy
    - action: allow
      permissions:
        - read
        - write
        - create
      subjects:
        - deploy:nikolaichev-test.nikolaichev-stage-per-location.MAINTAINER
      attributes:
        - ''
        - /spec
        - /labels
        - /annotations
        - /meta/project_id
    - action: allow
      permissions:
        - ssh_access
        - root_ssh_access
      subjects:
        - deploy:nikolaichev-test.nikolaichev-stage-per-location.MAINTAINER
      attributes:
        - /access/deploy/box/default
    - action: allow
      permissions:
        - use
      subjects:
        - >-
          deploy:nikolaichev-test.nikolaichev-stage-per-location.MANDATORY_APPROVER
      attributes:
        - /access/deploy/mandatory_approvers
    - action: allow
      permissions:
        - write
      subjects:
        - >-
          deploy:nikolaichev-test.nikolaichev-stage-per-location.MANDATORY_APPROVER
      attributes:
        - /control/approve
        - /control/disapprove
    - action: allow
      permissions:
        - read
      subjects:
        - >-
          deploy:nikolaichev-test.nikolaichev-stage-per-location.MANDATORY_APPROVER
  account_id: abc:service:3494
  key: nikolaichev-stage-per-location
  uuid: 8b9ec6fb-d32ce6b8-1fc4930d-72e833dc
labels:
  deploy_engine: env_controller
  du_patchers_target_revision:
    deployUnit_MCRS: 11
    parallel-strategy: 11
    sequential-strategy: 11
  du_sidecar_target_revision:
    deployUnit_MCRS:
      logbrokerToolsLayer: 2739742779
      podBin: 2936629847
    parallel-strategy:
      podBin: 2936629847
    sequential-strategy:
      logbrokerToolsLayer: 2739742779
      podBin: 2936629847
  notifications_last_timestamp: 1650460105614683000
  stagectl_epoch: 589
  stagectl_vcs:
    svn_branch: stage_controller/stable-108-2
    svn_revision: 7951591
    svn_tag: stage_controller/stable-108-2
  tags: []
`;

export const StageYaml = Template.bind({});
StageYaml.args = {
    value: stageYaml,
    uri: 'monaco://schema.yaml/stage',
};

export const StageYamlDark = Template.bind({});
StageYamlDark.args = {
    value: stageYaml,
    uri: 'monaco://schema.yaml/stage',
    theme: 'infracloud-ui-dark',
};

export default {
    component: YamlEditor,
    title: 'YamlEditor',
} as ComponentMeta<typeof YamlEditor>;
